% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qualityControl.R
\docType{methods}
\name{qualityControl}
\alias{qualityControl}
\alias{qualityControl,RasterStackBrick-method}
\title{Perform Quality Control on GIMMS NDVI3g Data}
\usage{
\S4method{qualityControl}{RasterStackBrick}(x, keep = NULL, filename = "",
  ...)
}
\arguments{
\item{x}{A single 2-layered \code{RasterStack} object (NDVI and flags).}

\item{keep}{\code{integer}. Accepted flag values (see 'Details').}

\item{filename}{\code{character}. Optional output filename.}

\item{...}{Further arguments passed to \code{\link{writeRaster}}.}
}
\value{
A quality-controlled 'RasterLayer' object.
}
\description{
Perform quality control on GIMMS NDVI3g data based on the companion flag
information. This is merely a wrapper around \code{\link{overlay}} and, since
quality control is readily available through \code{\link{rasterizeGimms}}, it
is strongly recommended to use the latter function for this purpose.
}
\details{
If 'keep' is missing, the function will automatically skip quality control
and return the input object.
}
\examples{
## see 'Examples' section in ?rasterizeGimms

}
\seealso{
\code{\link{rasterizeGimms}}, \code{\link{overlay}}.
}

