% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggSEM.R
\name{aggSEM}
\alias{aggSEM}
\title{Group-level structural equation model search.}
\usage{
aggSEM(data   = "",
       out    = "",
       sep    = "",
       header = ,
       ar     = TRUE,
       plot   = TRUE,
       paths  = NULL)
}
\arguments{
\item{data}{The path to the directory where the data files are located. Each file must contain one matrix for
each individual containing a T (time) by p (number of variables) matrix where the columns represent variables
and the rows represent time.}

\item{out}{The path to the directory where the results will be stored. This directory must be generated
by the user prior to running the function.}

\item{sep}{The spacing of the data files. "" indicates space-delimited, "/t" indicates tab-delimited, ","
indicates comma delimited.}

\item{header}{Logical. Indicate TRUE for data files with a header.}

\item{ar}{Logical. If TRUE, begins search for group model with autoregressive (AR) paths open. Defaults
to TRUE.}

\item{plot}{Logical. If TRUE, graphs depicting relations among variables of interest will automatically
be created. For aggregate-level plot, red paths represent positive weights and blue paths represent negative weights. Defaults to TRUE.}

\item{paths}{\code{lavaan}-style syntax containing paths with which to begin model estimation. That is, Y~X indicates that Y is regressed on X, or X predicts Y. If no header is used,
then variables should be referred to with V followed (with no separation) by the column number. If a
header is used, variables should be referred to using variable names. To reference lag variables, "lag"
should be added to the end of the variable name with no separation. Defaults to NULL.}
}
\description{
Concatenates all individual-level data files and fits a group model to the data.
}
\details{
In main output directory:
 \itemize{
 \item{\strong{allBetas}} Matrix. Contains estimates for each path in the aggregate-level model. The row variable is the outcome and the column variable is the predictor variable.
 \item{\strong{allStdErrors}} Matrix. Contains standard errors for each path in the aggregate-level model. The row variable is the outcome and the column variable is the predictor variable.
 \item{\strong{allPathEstimates}} {Contains estimate, standard error, p-value, and z-value for each path for the concatenated data.}
 \item{\strong{summaryFit}} {Contains model fit information for the aggregate-level model.}
 \item{\strong{summaryPathsPlot}} Contains aggregate-level plot. Red paths represent positive weights and blue paths represent negative weights.
}
}
\examples{
data(ts1,ts2,ts3,ts4,ts5)
input.path  <- file.path(tempdir(),"input")
output.path <- file.path(tempdir(),"output")
dir.create(input.path)
dir.create(output.path)
write.table(ts1,file.path(input.path,"ts1.txt"),col.names=FALSE,row.names=FALSE)
write.table(ts2,file.path(input.path,"ts2.txt"),col.names=FALSE,row.names=FALSE)
write.table(ts3,file.path(input.path,"ts3.txt"),col.names=FALSE,row.names=FALSE)
write.table(ts4,file.path(input.path,"ts4.txt"),col.names=FALSE,row.names=FALSE)
write.table(ts5,file.path(input.path,"ts5.txt"),col.names=FALSE,row.names=FALSE)
aggSEM(data   = input.path,
       out    = output.path,
       sep    = "",
       header = FALSE,
       ar     = TRUE,
       plot   = TRUE,
       paths  = NULL)
}
\author{
Stephanie Lane
}

