% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-gi.R
\name{plot_volcano}
\alias{plot_volcano}
\title{Volcano plot for GI scores}
\usage{
plot_volcano(gimap_dataset, facet_rep = FALSE)
}
\arguments{
\item{gimap_dataset}{A special dataset structure that is originally setup using `setup_data()` and has had gi scores calculated with `calc_gi()`.}

\item{facet_rep}{Should the replicates be wrapped with facet_wrap()?}
}
\value{
A ggplot2 volcano plot of the target level genetic interaction scores.
}
\description{
This plot is meant to be functionally equivalent to Fig 5b (for HeLa, equivalent of Fig 3d for PC9).
Volcano plot of target-level GI scores
Blue points are synthetic lethal paralog GIs with GI < 0.5 and FDR < 0.1; red points are buffering paralog GIs with GI > 0.25 and FDR < 0.1.
}
\examples{
\donttest{

gimap_dataset <- get_example_data("gimap") \%>\%
  gimap_filter() \%>\%
  gimap_annotate(cell_line = "HELA") \%>\%
  gimap_normalize(
    timepoints = "day"
  ) \%>\%
  calc_gi()

# To plot results
plot_exp_v_obs_scatter(gimap_dataset)
plot_rank_scatter(gimap_dataset)
plot_volcano(gimap_dataset)
}
}
