% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palettes.R
\name{ghibli_palette}
\alias{ghibli_palette}
\title{A Studio Ghibli palette generator}
\usage{
ghibli_palette(name, n, direction = 1, type = c("discrete",
  "continuous"))
}
\arguments{
\item{name}{Name of desired palette.}

\item{n}{Number of colors desired. All palettes now only have seven colors.
All color schemes are derived from this Studio Ghibli retrospective:
\href{http://www.thelovemagazine.co.uk/posts/6584/in-photos-guess-who-s-back-retrospective-of-studio-ghibli-forever-is-here}{Studio Ghibli retrospective}.
If omitted, uses all colours.}

\item{direction}{Either `1` or `-1`. If `-1` the palette will be reversed.}

\item{type}{Either "continuous" or "discrete". Use continuous if you want
to automatically interpolate between colours.}
}
\value{
A vector of colours.
}
\description{
These are some color palettes from Studio Ghibli films.
}
\examples{
ghibli_palette("PonyoLight")
ghibli_palette("LaputaMedium")
ghibli_palette("SpiritedDark")
ghibli_palette("MarnieMedium2", 3)

# If you need more colours than normally found in a palette, you
# can use a continuous palette to interpolate between existing
# colours
pal <- ghibli_palette(21, name = "YesterdayLight", type = "continuous")
}
\keyword{colors}
