% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/broker.R
\name{create_broker}
\alias{create_broker}
\title{Create a broker object}
\usage{
create_broker(r, controls = NULL, connect = NULL, spec = NULL)
}
\arguments{
\item{r}{A reactive expression.}

\item{controls}{An HTML control, or a list of HTML controls.}

\item{connect}{A function to run at render time. This function takes the
Shiny \code{session} object as its only argument, and is used to connect
the session with the broker object.}

\item{spec}{Object to put in the Vega spec.}
}
\description{
A broker is a subclass of reactive. It can hold extra information to
facilitate (or broker) communication between the client and the server.
For example, an input broker may contain HTML controls to be emitted on the
client web page, as well as a function to connect the inputs from the client
to the reactive expression.
}
\details{
Other types of brokers are possible. Another broker may create reactive
observers and add information to the Vega spec, instead of having HTML
controls. In this case, a reactive expression is still needed, although
it can be a dummy value, like \code{reactive(NULL)}.
}
\keyword{internal}

