% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_confidence_interval.R
\name{add_confidence_interval}
\alias{add_confidence_interval}
\title{Add Confidence Interval}
\usage{
add_confidence_interval(type = c("ribbon", "lines"), ...)
}
\arguments{
\item{type}{string indicating the type of confidence interval to draw.
Must be one of \code{c("ribbon", "lines")}}

\item{...}{arguments pass to geom.
\itemize{
\item \code{type = 'ribbon'}: Defaults are \code{ggplot2::geom_ribbon(alpha = 0.2, color = NA, ...)}
\item \code{type = 'lines'}: Defaults are \code{ggplot2::geom_step(linetype = "dashed", na.rm = TRUE, ...)}
}}
}
\value{
a ggplot2 figure
}
\description{
Add a confidence interval represented by either a ribbon or lines.
}
\examples{
survfit2(Surv(time, status) ~ sex, data = df_lung) \%>\%
  ggsurvfit() +
  add_confidence_interval()

survfit2(Surv(time, status) ~ 1, data = df_lung) \%>\%
  ggsurvfit() +
  add_confidence_interval(type = "lines")
}
\seealso{
Visit the \href{https://www.danieldsjoberg.com/ggsurvfit/articles/gallery.html}{gallery} for examples modifying the default figures
}
