% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label.R
\name{label_power10}
\alias{label_power10}
\title{Format numbers as power-of-10 R expressions}
\usage{
label_power10(
  decimal.mark = NULL,
  digits = 3,
  scale = 1,
  prefix = "",
  suffix = "",
  magnitude_only = FALSE,
  ...
)
}
\arguments{
\item{decimal.mark}{Character used as decimal separator. If \code{NULL} (default),
The default (NULL) retrieves the setting from [\code{\link[scales:number_options]{scales::number_options()}}].}

\item{digits}{Number of significant digits to show in the mantissa.}

\item{scale}{Scaling factor multiplied to the input values. Default is \code{1}.}

\item{prefix}{Character string to prepend to each label. Default is \code{""}.}

\item{suffix}{Character string to append to each label. Default is \code{""}.}

\item{magnitude_only}{Logical. If \code{TRUE}, shows only the power-of-10 part
(e.g., \eqn{10^5} instead of \eqn{1\times 10^5}). Default is \code{FALSE}.}

\item{...}{Additional arguments passed to \code{\link[scales:scientific_format]{scales::scientific()}}.}
}
\value{
A label function that takes a numeric vector and returns an expression
vector suitable for use as axis labels in ggplot2.
}
\description{
Creates a labeller function that formats numbers in scientific notation using
power-of-10 R expressions (e.g., \eqn{2.5\times 10^3} or \eqn{5\times 10^6}). Useful for axis
labels in ggplot2 when dealing with large numbers or when you want to emphasize
the order of magnitude.
}
\details{
The function converts numbers to scientific notation and then formats them
as mathematical expressions using the R expression syntax:
\itemize{
\item For exponent 0: returns the mantissa as-is (e.g., \eqn{5.5})
\item For exponent 1: it omits the exponent (e.g., \eqn{1.5\times 10})
\item For other exponents: everything is shown (e.g., \eqn{1.5\times 10^3})
}

When \code{magnitude_only = TRUE}:
\itemize{
\item For exponent 0: returns \eqn{1}
\item For exponent 1: returns \eqn{10}
\item For other exponents (positive or negative): returns \eqn{10^{exponent}}
}

The function handles negative numbers by preserving the sign and supports
custom decimal marks, prefixes, and suffixes.
}
\examples{
library(ggplot2)

# Basic usage with default settings
label_power10()(c(1000, 10000, 100000, -1000))

# Use in ggplot2
ggplot(
  data.frame(x = 1:5, y = c(1, 50000, 75000, 100000, 200000)),
  aes(x, y)
) +
  geom_point() +
  scale_y_continuous(labels = label_power10())

# Use in ggplot2 with options
ggplot(
  data.frame(x = 1:5, y = c(1, 50000, 75000, 100000, 200000)),
  aes(x, y)
) +
  geom_point() +
  scale_y_continuous(labels = label_power10(decimal.mark = ",", digits = 2, suffix = " CFU"))

# Magnitude only for cleaner labels with log scales
ggplot(
  data.frame(x = 1:5, y = c(1000, 10000, 100000, 1000000, 10000000)),
  aes(x, y)
) +
  geom_point() +
  scale_y_log10(labels = label_power10(magnitude_only = TRUE))

}
