% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_gghistostats_graphics.R
\name{histo_labeller}
\alias{histo_labeller}
\title{Custom function for adding labeled lines for \code{x}-axis variable.}
\usage{
histo_labeller(
  plot,
  x,
  type = "parametric",
  tr = 0.2,
  k = 2L,
  centrality.line.args = list(color = "blue", size = 1),
  ...
)
}
\arguments{
\item{plot}{A \code{ggplot} object for which the labeled lines need to be added
for a test value and/or a centrality parameter (mean/median) value.}

\item{x}{A numeric variable from the dataframe \code{data}.}

\item{type}{A character specifying the type of statistical approach.
Four possible options:

\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

Corresponding abbreviations are also accepted: \code{"p"} (for parametric),
\code{"np"} (for nonparametric), \code{"r"} (for robust), or \code{"bf"} (for Bayesian).}

\item{tr}{Trim level for the mean when carrying out \code{robust} tests. In case
of an error, try reducing the value of \code{tr}, which is by default set to
\code{0.2}. Lowering the value might help.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{centrality.line.args}{A list of additional aesthetic arguments to be
passed to the \code{geom_line} used to display the lines corresponding to the
centrality parameter.}

\item{...}{Currently ignored.}
}
\description{
Helper function for adding centrality parameter value and/or a
test value for the continuous, numeric \code{x}-axis variable.
}
\examples{
\donttest{
library(ggplot2)

# creating a plot; lines and labels will be superposed on this plot
p <- ggplot(mtcars, aes(wt, mpg)) +
  geom_point()

# adding labels
ggstatsplot:::histo_labeller(
  plot = p,
  x = mtcars$wt
)
}
}
\keyword{internal}
