% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggbetweenstats.R
\name{ggsignif_adder}
\alias{ggsignif_adder}
\title{Adding \code{geom_signif} to the plot.}
\usage{
ggsignif_adder(plot, df_pairwise, data, pairwise.annotation = "asterisk",
  pairwise.display = "significant")
}
\arguments{
\item{plot}{A \code{ggplot} object on which \code{geom_signif} needed to be added.}

\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{pairwise.annotation}{Character that decides the annotations to use for
pairwise comparisons. Either \code{"p.value"} or \code{"asterisk"} (default).}

\item{pairwise.display}{Decides which pairwise comparisons to display.
Available options are \code{"significant"} (abbreviation accepted: \code{"s"}) or
\code{"non-significant"} (abbreviation accepted: \code{"ns"}) or
\code{"everything"}/\code{"all"}. The default is \code{"significant"}. You can use this
argument to make sure that your plot is not uber-cluttered when you have
multiple groups being compared and scores of pairwise comparisons being
displayed.}
}
\description{
Adding \code{geom_signif} to the plot.
}
\examples{
\dontrun{
library(ggplot2)

# data
df <- data.frame(x = iris$Species, y = iris$Sepal.Length)

# plot
p <- ggplot(df, aes(x, y)) + geom_boxplot()

# dataframe with pairwise comparison test results
df_pair <- ggstatsplot::pairwise_p(df, x, y)

# adding plot with
ggstatsplot:::ggsignif_adder(
  plot = p,
  df_pairwise = df_pair,
  data = df
)
}

}
\keyword{internal}
