% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-spatial.R
\name{geom_spatial}
\alias{geom_spatial}
\alias{geom_spatial.SpatialLines}
\alias{geom_spatial.SpatialLinesDataFrame}
\alias{geom_spatial.SpatialPoints}
\alias{geom_spatial.SpatialPointsDataFrame}
\alias{geom_spatial.SpatialPolygons}
\alias{geom_spatial.SpatialPolygonsDataFrame}
\alias{geom_spatial.default}
\alias{ggspatial}
\title{A ggplot2 geom for Spatial* objects}
\usage{
geom_spatial(data, ...)

ggspatial(data, mapping = NULL, ...)

\method{geom_spatial}{default}(data, mapping = NULL, show.legend = TRUE,
  inherit.aes = NULL, position = "identity", crsfrom = NA, crsto = NA,
  geom = "point", ...)

\method{geom_spatial}{SpatialPoints}(data, mapping = NULL,
  show.legend = TRUE, inherit.aes = NULL, position = "identity",
  crsfrom = NA, crsto = NA, attribute_table = NULL, ...)

\method{geom_spatial}{SpatialPointsDataFrame}(data, mapping = NULL,
  show.legend = TRUE, inherit.aes = NULL, position = "identity",
  crsfrom = NA, crsto = NA, ...)

\method{geom_spatial}{SpatialLines}(data, mapping = NULL,
  show.legend = TRUE, inherit.aes = NULL, position = "identity",
  crsfrom = NA, crsto = NA, attribute_table = NULL, ...)

\method{geom_spatial}{SpatialLinesDataFrame}(data, mapping = NULL,
  show.legend = TRUE, inherit.aes = NULL, position = "identity",
  crsfrom = NA, crsto = NA, ...)

\method{geom_spatial}{SpatialPolygons}(data, mapping = NULL,
  show.legend = TRUE, inherit.aes = NULL, position = "identity",
  crsfrom = NA, crsto = NA, rule = "winding", attribute_table = NULL,
  ...)

\method{geom_spatial}{SpatialPolygonsDataFrame}(data, mapping = NULL,
  show.legend = TRUE, inherit.aes = NULL, position = "identity",
  crsfrom = NA, crsto = NA, rule = "winding", ...)
}
\arguments{
\item{data}{A \code{Spatial*} object or \code{data.frame}.}

\item{...}{Agruments passed on to the \code{geom_*} (e.g. \code{lwd}, \code{fill}, etc.)}

\item{mapping}{A mapping as created by \code{aes()} or \code{aes_string()}}

\item{show.legend}{Logical describing the legend visibility.}

\item{inherit.aes}{Logical describing if aesthetics are inherited}

\item{position}{Passed on to geom_*}

\item{crsfrom}{An object that can be coerced to a CRS using \link{as.CRS}; defaults
to the CRS of the data or lat/lon if that does not exist}

\item{crsto}{An object that can be coerced to a CRS using \link{as.CRS}; defaults to
lat/lon so that the plot can be projected using coord_map()}

\item{geom}{For data frames, the geometry to use}

\item{attribute_table}{For SpatialPoints, SpatialLines, and SpatialPolygons, an attribute
table that matches the input object.}

\item{rule}{One of 'evenodd' or 'winding', if the Spatial object is a polygon layer.}
}
\value{
A ggplot2 'layer' object.
}
\description{
A function returning a geom_* object based on the Spatial* input. Also will
happily project a regular \code{data.frame} provided x and y aesthetics are
specified. The result is a \code{geom_*} for use with ggplot2, with aesthetics
and other argumets passed on to that geom.
}
\examples{
\donttest{
library(prettymapr)
ns <- searchbbox("Nova Scotia")
cities <- geocode(c("Wolfville, NS", "Windsor, NS", "Halifax, NS"))
ggplot(cities, aes(x=lon, y=lat)) + geom_spatial(crsto=26920)
# default projection is Spherical Mercator (EPSG:3857)
ggplot(cities, aes(x=lon, y=lat)) + geom_spatial() + coord_map()
}

# plot a number of spatial objects
ggplot() +
  geom_spatial(longlake_waterdf, fill="lightblue") +
  geom_spatial(longlake_marshdf, fill="grey", alpha=0.5) +
  geom_spatial(longlake_streamsdf, col="lightblue") +
  geom_spatial(longlake_roadsdf, col="black") +
  geom_spatial(longlake_buildingsdf, pch=1, col="brown", size=0.25) +
  coord_map()

}

