% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract-projection.R
\name{as.CRS}
\alias{as.CRS}
\title{Extract a projection from an object}
\usage{
as.CRS(x)
}
\arguments{
\item{x}{An object}
}
\value{
A CRS object, or NA if one cannot be extracted
}
\description{
Many functions in this package require projection information. This function
allows a CRS to be extracted from various objects, notably Spatial*,
Raster*, and integers (which are assumed to be EPSG codes). This allows
for less verbose syntax when dealing with projections in this package.
}
\examples{
as.CRS(4326) # integer
as.CRS(longlake_osm) # raster
as.CRS(longlake_waterdf) # spatial

}

