% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal-doc.r, R/scale-shadow.r
\name{scale_manual}
\alias{scale_shadowcolour_manual}
\title{Create your own discrete scale}
\usage{
scale_shadowcolour_manual(
  ...,
  values,
  aesthetics = "shadowcolour",
  breaks = waiver()
)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale}}
  \describe{
    \item{\code{scale_name}}{The name of the scale that should be used for error messages
associated with this scale.}
    \item{\code{palette}}{A palette function that when called with a single integer
argument (the number of levels in the scale) returns the values that
they should take (e.g., \code{\link[scales:hue_pal]{scales::hue_pal()}}).}
    \item{\code{name}}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
    \item{\code{labels}}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels
as output
}}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale values
\item A character vector that defines possible values of the scale and their
order
\item A function that accepts the existing (automatic) values and returns
new ones
}}
    \item{\code{na.translate}}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
    \item{\code{na.value}}{If \code{na.translate = TRUE}, what aesthetic value should the
missing values be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}
    \item{\code{drop}}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} uses all the levels in the factor.}
    \item{\code{guide}}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}

\item{values}{a set of aesthetic values to map data values to. The values
will be matched in order (usually alphabetical) with the limits of the
scale, or with `breaks` if provided. If this is a named vector, then the
values will be matched based on the names instead. Data values that don't
match will be given `na.value`.}

\item{aesthetics}{Character string or vector of character strings listing the
name(s) of the aesthetic(s) that this scale works with. This can be useful, for
example, to apply colour settings to the `colour` and `fill` aesthetics at the
same time, via `aesthetics = c("colour", "fill")`.}

\item{breaks}{One of:
- `NULL` for no breaks
- `waiver()` for the default breaks (the scale limits)
- A character vector of breaks
- A function that takes the limits as input and returns breaks
  as output}
}
\value{
a scale object to add to a plot.
}
\description{
These functions allow you to specify your own set of mappings from levels in the
data to aesthetic values.
}
\details{
The functions `scale_colour_manual()`, `scale_fill_manual()`, `scale_size_manual()`,
etc. work on the aesthetics specified in the scale name: `colour`, `fill`, `size`,
etc. However, the functions `scale_colour_manual()` and `scale_fill_manual()` also
have an optional `aesthetics` argument that can be used to define both `colour` and
`fill` aesthetic mappings via a single function call (see examples). The function
`scale_discrete_manual()` is a generic scale that can work with any aesthetic or set
of aesthetics provided via the `aesthetics` argument.
}
\section{Color Blindness}{

Many color palettes derived from RGB combinations (like the "rainbow" color
palette) are not suitable to support all viewers, especially those with
color vision deficiencies. Using `viridis` type, which is perceptually
uniform in both colour and black-and-white display is an easy option to
ensure good perceptive properties of your visulizations.
The colorspace package offers functionalities
- to generate color palettes with good perceptive properties,
- to analyse a given color palette, like emulating color blindness,
- and to modify a given color palette for better perceptivity.

For more information on color vision deficiencies and suitable color choices
see the [paper on the colorspace package](https://arxiv.org/abs/1903.06490)
and references therein.
}

\examples{
library( ggplot2 )
p <- ggplot(mtcars, aes(wt, mpg, shadowcolour=as.factor(gear)))
p <- p + geom_glowpoint() + guides(shadowcolour='none')
p + scale_shadowcolour_manual(values=c('red', 'blue', 'green'))

}
