% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-lancet.R
\name{scale_color_lancet}
\alias{scale_color_lancet}
\alias{scale_colour_lancet}
\alias{scale_fill_lancet}
\title{Lancet Journal Color Scales}
\usage{
scale_color_lancet(palette = c("lanonc"), alpha = 1, ...)

scale_colour_lancet(palette = c("lanonc"), alpha = 1, ...)

scale_fill_lancet(palette = c("lanonc"), alpha = 1, ...)
}
\arguments{
\item{palette}{Palette type.
Currently there is one available option: \code{"lanonc"}
(9-color palette inspired by \emph{Lancet Oncology}).}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices]{rgb}} for details.}

\item{...}{additional parameters for \code{\link[ggplot2]{discrete_scale}}}
}
\description{
See \code{\link{pal_lancet}} for details.
}
\examples{
library("ggplot2")
data("diamonds")

ggplot(
  subset(diamonds, carat >= 2.2),
  aes(x = table, y = price, colour = cut)
) +
  geom_point(alpha = 0.7) +
  geom_smooth(method = "loess", alpha = 0.1, size = 1, span = 1) +
  theme_bw() +
  scale_color_lancet()

ggplot(
  subset(diamonds, carat > 2.2 & depth > 55 & depth < 70),
  aes(x = depth, fill = cut)
) +
  geom_histogram(colour = "black", binwidth = 1, position = "dodge") +
  theme_bw() +
  scale_fill_lancet()
}
\author{
Nan Xiao <\email{me@nanx.me}> |
<\href{https://nanx.me}{https://nanx.me}>
}
