% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-point.R
\name{scale_point}
\alias{scale_point_shape}
\alias{scale_point_size_continuous}
\alias{scale_point_color_hue}
\alias{scale_point_fill_hue}
\alias{scale_point_color_gradient}
\alias{scale_point_fill_gradient}
\alias{scale_point_shape_discrete}
\alias{scale_point_color_discrete}
\alias{scale_point_fill_discrete}
\alias{scale_point_color_continuous}
\alias{scale_point_fill_continuous}
\title{Scales for point aesthetics}
\description{
These are various scales that can be applied to point aesthetics, such as
\code{point_color}, \code{point_fill}, \code{point_size}. The individual scales all have the
same usage as existing standard ggplot2 scales, only the name differs.

\code{scale_point_shape()}: Equivalent to \code{\link[=scale_shape]{scale_shape()}}.

\code{scale_point_size_continuous()}: Equivalent to \code{\link[=scale_size_continuous]{scale_size_continuous()}}.

\code{scale_point_color_hue()}: Equivalent to \code{\link[=scale_colour_hue]{scale_colour_hue()}}.

\code{scale_point_fill_hue()}: Equivalent to \code{\link[=scale_fill_hue]{scale_fill_hue()}}.

\code{scale_point_color_gradient()}: Equivalent to \code{\link[=scale_colour_gradient]{scale_colour_gradient()}}. Note that this scale cannot
draw a legend, however, because of limitations in \code{\link[=guide_colorbar]{guide_colorbar()}}.

\code{scale_point_fill_gradient()}: Equivalent to \code{\link[=scale_fill_gradient]{scale_fill_gradient()}}. Note that this scale cannot
draw a legend, however, because of limitations in \code{\link[=guide_colorbar]{guide_colorbar()}}.
}
\examples{
library(ggplot2)

# default scales
ggplot(iris, aes(x=Sepal.Length, y=Species, fill = Species)) +
  geom_density_ridges(aes(point_color = Species, point_fill = Species,
                          point_shape = Species),
                      alpha = .4, jittered_points = TRUE) +
  theme_ridges()

# modified scales
ggplot(iris, aes(x=Sepal.Length, y=Species, fill = Species)) +
  geom_density_ridges(aes(point_color = Species, point_fill = Species,
                          point_shape = Species),
                      alpha = .4, jittered_points = TRUE) +
  scale_fill_hue(l = 50) +
  scale_point_color_hue(l = 20) +
  scale_point_fill_hue(l = 70) +
  scale_discrete_manual("point_shape", values = c(21, 22, 23)) +
  theme_ridges()
}
\seealso{
See \code{\link[=scale_vline_color_hue]{scale_vline_color_hue()}} for specific scales for vline aesthetics
and \code{\link[=scale_discrete_manual]{scale_discrete_manual()}} for a general discrete scale.
}
