% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_fabric.R
\name{layout_tbl_graph_fabric}
\alias{layout_tbl_graph_fabric}
\alias{node_rank_fabric}
\title{Create a fabric layout}
\usage{
layout_tbl_graph_fabric(
  graph,
  circular = FALSE,
  sort.by = NULL,
  shadow.edges = FALSE
)

node_rank_fabric()
}
\arguments{
\item{graph}{An \code{tbl_graph} object}

\item{circular}{Ignored}

\item{sort.by}{An expression providing the sorting of the nodes. If \code{NULL}
the nodes will be ordered by their index in the graph.}

\item{shadow.edges}{Should shadow edges be shown.}
}
\value{
A data.frame with the columns \code{x}, \code{xmin}, \code{xmax}, \code{y}, \code{circular} as
well as any information stored as node variables in the tbl_graph object.
Further, the edges of the graph will gain a \code{edge_x} variable giving the
horizontal position of the edge as well as a \code{shadow_edge} variable denoting
whether the edge is a shadow edge added by the layout.
}
\description{
This layout is a bit unusual in that it shows nodes as horizontal line ranges
end edges as evenly spaced vertical spans connecting the nodes. As with the
matrix layout the strength comes from better scalability but its use require
some experience recognising the patterns that different connectivity features
gives rise to. As with matrix layouts the ordering of nodes have huge power
over the look of the plot. The \code{node_rank_fabric()} mimics the default
ordering from the original BioFabric implementation, but other ranking
algorithms from tidygraph can be used with the \code{sort.by} argument as well.
Fabric layouts tend to become quite wide as the graph grows which is
something that should be handled with care - e.g. by only zooming in on a
specific region.
}
\references{
BioFabric website: \url{http://www.biofabric.org}

Longabaugh, William J.R. (2012).
\emph{Combing the hairball with BioFabric: a new approach for visualization of large networks}.
BMC Bioinformatics, 13: 275. \url{https://doi.org/10.1186/1471-2105-13-275}
}
\seealso{
Other layout_tbl_graph_*: 
\code{\link{layout_tbl_graph_auto}()},
\code{\link{layout_tbl_graph_backbone}()},
\code{\link{layout_tbl_graph_centrality}()},
\code{\link{layout_tbl_graph_circlepack}()},
\code{\link{layout_tbl_graph_dendrogram}()},
\code{\link{layout_tbl_graph_eigen}()},
\code{\link{layout_tbl_graph_focus}()},
\code{\link{layout_tbl_graph_hive}()},
\code{\link{layout_tbl_graph_igraph}()},
\code{\link{layout_tbl_graph_linear}()},
\code{\link{layout_tbl_graph_manual}()},
\code{\link{layout_tbl_graph_matrix}()},
\code{\link{layout_tbl_graph_partition}()},
\code{\link{layout_tbl_graph_pmds}()},
\code{\link{layout_tbl_graph_stress}()},
\code{\link{layout_tbl_graph_treemap}()},
\code{\link{layout_tbl_graph_unrooted}()}
}
\concept{layout_tbl_graph_*}
