% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdotchart.R
\name{ggdotchart}
\alias{ggdotchart}
\title{Cleveland's Dot Plots}
\usage{
ggdotchart(data, x, label, group = NULL, color = "black", palette = NULL,
  shape = 19, size = 1, sorting = c("descending", "ascending"),
  orientation = c("vertical", "horizontal"), ggtheme = theme_bw(), ...)
}
\arguments{
\item{data}{a data frame}

\item{x}{x variable for drawing.}

\item{label}{the name of the column containing point labels.}

\item{group}{an optional column name indicating how the elements of x are
grouped.}

\item{color, size}{points color and size.}

\item{palette}{the color palette to be used for coloring or filling by
groups. Allowed values include "grey" for grey color palettes; brewer
palettes e.g. "RdBu", "Blues", ...; or custom color palette e.g. c("blue",
"red"); and scientific journal palettes from ggsci R package, e.g.: "npg", "aaas", "lancet", "jco",
"ucscgb", "uchicago", "simpsons" and "rickandmorty".}

\item{shape}{point shape. See \code{\link{show_point_shapes}}.}

\item{sorting}{a character vector for sorting into ascending or descending
order. Allowed values are one of "descending" and "ascending". Partial
match are allowed (e.g. sorting = "desc" or "asc"). Default is
"descending".}

\item{orientation}{change the orientation of the plot. Allowed values are one
of c( "vertical", "horizontal", "reverse"). Partial match is allowed.}

\item{ggtheme}{function, ggplot2 theme name. Default value is theme_pubr().
Allowed values include ggplot2 official themes: theme_gray(), theme_bw(),
theme_minimal(), theme_classic(), theme_void(), ....}

\item{...}{other arguments to be passed to \code{\link[ggplot2]{geom_point}}
and \code{\link{ggpar}}.}
}
\description{
Draw a Cleveland dot plot.
}
\details{
The plot can be easily customized using the function ggpar(). Read
  ?ggpar for changing: \itemize{ \item main title and axis labels: main,
  xlab, ylab \item axis limits: xlim, ylim (e.g.: ylim = c(0, 30)) \item axis
  scales: xscale, yscale (e.g.: yscale = "log2") \item color palettes:
  palette = "Dark2" or palette = c("gray", "blue", "red") \item legend title,
  labels and position: legend = "right" \item plot orientation : orientation
  = c("vertical", "horizontal", "reverse") }
}
\examples{
# Load data
data("mtcars")
df <- mtcars
df$cyl <- as.factor(df$cyl)
df$name <- rownames(df)
head(df[, c("wt", "mpg", "cyl")], 3)

# Basic plot
ggdotchart(df, x = "mpg", label = "name" )

# Change colors by  group cyl
ggdotchart(df, x = "mpg", label = "name",
   group = "cyl", color = "cyl",
   palette = c('#999999','#E69F00','#56B4E9') )

# Use brewer palette
ggdotchart(df, x = "mpg", label = "name",
   group = "cyl", color = "cyl", palette = "Dark2" )

# Change the orientation
# Sort in ascending order
ggdotchart(df, x = "mpg", label = "name",
   group = "cyl", color = "cyl",
    palette = c("#00AFBB", "#E7B800", "#FC4E07"),
   orientation = "horizontal", sorting = "ascending" )


}
\seealso{
\code{\link{ggpar}}
}

