% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-edges.R
\name{geom_edgetext}
\alias{geom_edgetext}
\alias{geom_edgelabel}
\title{Label the edges of a network.}
\usage{
geom_edgetext(
  mapping = NULL,
  data = NULL,
  position = "identity",
  parse = FALSE,
  ...,
  nudge_x = 0,
  nudge_y = 0,
  label.padding = unit(0.25, "lines"),
  label.r = unit(0.15, "lines"),
  label.size = 0,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_edgelabel(
  mapping = NULL,
  data = NULL,
  position = "identity",
  parse = FALSE,
  ...,
  nudge_x = 0,
  nudge_y = 0,
  label.padding = unit(0.25, "lines"),
  label.r = unit(0.15, "lines"),
  label.size = 0,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function. Cannot be jointy specified with
\code{nudge_x} or \code{nudge_y}.}

\item{parse}{If \code{TRUE}, the labels will be parsed into expressions and
displayed as described in \code{?plotmath}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{nudge_x, nudge_y}{Horizontal and vertical adjustment to nudge labels by.
Useful for offsetting text from points, particularly on discrete scales.
Cannot be jointly specified with \code{position}.}

\item{label.padding}{Amount of padding around label. Defaults to 0.25 lines.}

\item{label.r}{Radius of rounded corners. Defaults to 0.15 lines.}

\item{label.size}{Size of label border, in mm.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\description{
All arguments to both \code{\link{geom_edgetext}} and
\code{\link{geom_edgelabel}} are identical to those of
\code{\link[ggplot2]{geom_label}}, with the only difference that the
\code{label.size} argument defaults to \code{0} in order to avoid drawing a
border around the edge labels. The labels will be drawn at mid-edges.
\code{\link{geom_text}} and \code{\link{geom_label}} produce strictly
identical results.
}
\examples{
if (require(network) && require(sna)) {
  data(flo, package = "network")
  n <- network(flo, directed = FALSE)

  # arbitrary categorical edge attribute
  e <- sample(letters[ 1:4 ], network.edgecount(n), replace = TRUE)
  set.edge.attribute(n, "type", e)

  # with labelled edges
  ggplot(n, aes(x, y, xend = xend, yend = yend)) +
    geom_edges(aes(colour = type)) +
    geom_edgetext(aes(label = type, colour = type)) +
    geom_nodes(size = 4, colour = "grey50") +
    theme_blank()

  # label only a subset of all edges with arbitrary symbol
  edge_type <- function(x) {
    x[ x$type == "a", ]
  }
  ggplot(n, aes(x, y, xend = xend, yend = yend)) +
    geom_edges() +
    geom_edgetext(label = "=", data = edge_type) +
    geom_nodes(size = 4, colour = "grey50") +
    theme_blank()
}

}
