% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_rms_norm_inplace}
\alias{ggml_rms_norm_inplace}
\title{RMS Normalization In-place (Graph)}
\usage{
ggml_rms_norm_inplace(ctx, a, eps = 1e-05)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor (will be modified in-place)}

\item{eps}{Epsilon value for numerical stability (default: 1e-5)}
}
\value{
View of input tensor with RMS normalization applied
}
\description{
Creates a graph node for in-place RMS normalization.
Returns a view of the input tensor.
CRITICAL for LLaMA models when memory efficiency is important.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 4)
ggml_set_f32(a, c(1, 2, 3, 4))
result <- ggml_rms_norm_inplace(ctx, a)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
ggml_free(ctx)
}
}
