% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/at_panel.R
\name{at_panel}
\alias{at_panel}
\title{Constrain layer to panels}
\usage{
at_panel(layer, expr)
}
\arguments{
\item{layer}{A \code{layer} as returned by \code{\link[ggplot2:layer]{layer()}}.}

\item{expr}{An \code{expression} that, when evaluated in the facet's layout
data.frame, yields a \code{logical} vector parallel to the rows.}
}
\value{
A modified \code{layer} which will only show in some panels.
}
\description{
This function limits the panels in which a layer is displayed. It can be
used to make panel-specific annotations.
}
\details{
The \code{expr} argument's expression will be evaluated in the context of the
plot's layout. This is an internal \code{data.frame} structure that isn't
ordinarily exposed to users, so it will require some extra knowledge. For
most facets, the layout describes the panels with one panel per row. It
typically has \code{COL}, \code{ROW} and \code{PANEL} columns that keep track of where a
panel goes in a grid-layout of cells. In addition, the layout contains the
facetting variables provided to the \code{facets} or \code{rows} and \code{cols} arguments
of the facets. For example, if we have a plot facetted on the \code{var} variable
with the levels \code{A}, \code{B} and \code{C}, as 1 row and 3 columns, we might target
the second \code{B} panel iwth any of these expressions: \code{var == "B"},
\code{PANEL == 2} or \code{COL == 2}. We can inspect the layout structure by using
\code{ggplot_build(p)$layout$layout}, wherein \code{p} is a plot.
}
\examples{
p <- ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  facet_grid(year ~ drv)

anno <- annotate("text", x = 3, y = 40, label = "My text")

# Target specific panels
p + at_panel(anno, PANEL \%in\% c(2, 4))

# Target a variable
p + at_panel(anno, drv == "f")

# Or combine variable with position
p + at_panel(anno, drv == "f" & ROW == 2)
}
