% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newplots.R
\name{stat_qqline}
\alias{stat_qqline}
\title{A Stat for Adding Reference Lines to QQ-Plots}
\usage{
stat_qqline(mapping = NULL, data = NULL, geom = "line",
  position = "identity", ..., distribution = stats::qnorm,
  dparams = list(), na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE)
}
\arguments{
\item{mapping}{An aesthetic mapping produced with \code{\link[=aes]{aes()}} or
\code{\link[=aes_string]{aes_string()}}.}

\item{data}{A data frame.}

\item{geom}{A geom.}

\item{position}{A position object.}

\item{...}{Additional arguments}

\item{distribution}{A quantile function.}

\item{dparams}{A list of arguments for \code{distribution}.}

\item{na.rm}{A logical indicating whether a warning should be issued when
missing values are removed before plotting.}

\item{show.legend}{A logical indicating whether legends should be included
for this layer.  If \code{NA}, legends will be include for each aesthetic
that is mapped.}

\item{inherit.aes}{A logical indicating whether aesthetics should be
inherited.  When \code{FALSE}, the supplied \code{mapping} will be
the only aesthetics used.}
}
\description{
This stat computes quantiles of the sample and theoretical distribution for
the purpose of providing reference lines for QQ-plots.
}
\examples{
ggplot(data = iris, aes(sample = Sepal.Length)) +
  geom_qq() +
  stat_qqline(alpha = 0.7, color = "red", linetype = "dashed") +
  facet_wrap(~Species)
}
