% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newplots.R
\name{stat_fitdistr}
\alias{stat_fitdistr}
\title{A stat for fitting distributions}
\usage{
stat_fitdistr(mapping = NULL, data = NULL, geom = "path",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, dist = "dnorm", start = NULL, ...)
}
\arguments{
\item{mapping}{Aesthetics created using \code{aes()} or \code{aes_string()}.}

\item{data}{A data frame.}

\item{geom}{A character string naming the geom used to make the layer.}

\item{position}{Either a character string naming the position function used
for the layer or a position object returned from a call to a position function.}

\item{na.rm}{If TRUE, do not emit a warning about missing data.}

\item{show.legend}{A logical. Should this layer be included in the legends? \code{NA},
the default, includes if any aesthetics are mapped. \code{FALSE} never includes,
and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather than combining
with them.}

\item{dist}{A character string indicating the distribution to fit.  Examlpes include
\code{"dnorm"}, \code{"dgamma"}, etc.}

\item{start}{A list of starting values used by \code{MASS::fitdistr()} when numerically
approximating the maximimum likelihood estimate.}

\item{...}{Additional arguments.}
}
\value{
A gg object
}
\description{
This stat computes points for plotting a distribution function.  Fitting is done
useing \code{MASS::fitdistr()} when analytic solutions are not available.
}
