% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allFunctions.R
\name{getBranchQuant}
\alias{getBranchQuant}
\title{Descendant branch calculations for quantitative variable}
\usage{
getBranchQuant(v1, geneal, colName, gen = 3)
}
\arguments{
\item{v1}{the label of the vertex of interest (in character string format)}

\item{geneal}{the full genealogy  (in data frame format)}

\item{colName}{the name of the column of the data frame that contains the quantitative variable of interest (in character string format)}

\item{gen}{the number of generations back to include as ancestors}
}
\description{
Returns a data frame containing the names of all children of an individual of interest ("Name"). The mean and standard deviation ("Mean" and "SD") of a quantitative variable across all descendents of each child is reported. In addition, for each child, the number of its descendants is reported ("Count"), the number of its descendants who do not have a value for the quantitative variable ("NACount") is reported, and the names of all of its descendants is reported ("DesNames").
}
\examples{
data(statGeneal)
DC_Year <- getBranchQuant("David Cox", statGeneal, "gradYear", 15)

}
