% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_data.R
\name{new_data}
\alias{new_data}
\alias{data_grid}
\title{Create a data frame from all combinations of predictor values}
\usage{
new_data(model, terms, typical = "mean", condition = NULL, ...)

data_grid(model, terms, typical = "mean", condition = NULL, ...)
}
\arguments{
\item{model}{A fitted model object.}

\item{terms}{Character vector with the names of those terms from
\code{model} for which all combinations of values should be created.}

\item{typical}{Character vector, naming the function to be applied to the
covariates over which the effect is "averaged". The default is "mean".
See \code{?sjmisc::typical_value} for options.}

\item{condition}{Named character vector, which indicates covariates that
should be held constant at specific values. Unlike \code{typical}, which
applies a function to the covariates to determine the value that is used
to hold these covariates constant, \code{condition} can be used to define
exact values, for instance \code{condition = c(covariate1 = 20, covariate2 = 5)}.
See 'Examples'.}

\item{...}{Currently not used.}
}
\value{
A data frame containing one row for each combination of values of the
supplied variables.
}
\description{
Create a data frame for the "newdata"-argument that contains
all combinations of values from the terms in questions. Similar to
\code{expand.grid()}. The \code{terms}-argument accepts all shortcuts
for representative values as in \code{ggpredict()}.
}
\examples{
data(efc)
fit <- lm(barthtot ~ c12hour + neg_c_7 + c161sex + c172code, data = efc)
new_data(fit, c("c12hour [meansd]", "c161sex"))

nd <- new_data(fit, c("c12hour [meansd]", "c161sex"))
pr <- predict(fit, type = "response", newdata = nd)
nd$predicted <- pr
nd

# compare to
ggpredict(fit, c("c12hour [meansd]", "c161sex"))

}
