% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{effectiveSize_hyper}
\alias{effectiveSize_hyper}
\alias{effectiveSize_many}
\alias{effectiveSize_one}
\alias{effectiveSize}
\title{Effective sample size}
\usage{
effectiveSize_hyper(x, start, end, digits, verbose)

effectiveSize_many(x, start, end, verbose)

effectiveSize_one(x, start, end, digits, verbose)

effectiveSize(x, hyper = FALSE, start = 1, end = NA, digits = 0,
  verbose = FALSE)
}
\arguments{
\item{x}{a samples object}

\item{start}{starting iteration}

\item{end}{ending iteraton}

\item{digits}{printing digits}

\item{verbose}{printing more information}

\item{hyper}{a switch to extract hyper attribute and calculate it}
}
\description{
\code{effectiveSize} calls \pkg{coda} effectiveSize to calculate
effective posterior sample size.
}
\examples{
#################################40
## effectiveSize example
#################################40
\dontrun{
es1 <- effectiveSize_one(hsam[[1]], 1, 100, 2, TRUE)
es2 <- effectiveSize_one(hsam[[1]], 1, 100, 2, FALSE)
es3 <- effectiveSize_many(hsam, 1, 100, TRUE)
es4 <- effectiveSize_many(hsam, 1, 100, FALSE)
es5 <- effectiveSize_hyper(hsam, 1, 100, 2)
es6 <- effectiveSize(hsam, TRUE, 1, 100, 2, TRUE)
es7 <- effectiveSize(hsam, TRUE, 1, 100, 2, FALSE)
es8 <- effectiveSize(hsam, FALSE, 1, 100, 2, TRUE)
es9 <- effectiveSize(hsam, FALSE, 1, 100, 2, FALSE)
es10 <- effectiveSize(hsam[[1]], FALSE, 1, 100, 2, TRUE)
}
}
