% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dark_mode.R
\name{invert_geom_defaults}
\alias{invert_geom_defaults}
\title{Invert geom defaults for fill and color/colour}
\usage{
invert_geom_defaults(geoms = get_geoms())
}
\arguments{
\item{geoms}{List of geoms as ggproto objects}
}
\description{
Invert geom defaults for fill and color/colour
}
\examples{
library(ggplot2)

p <- ggplot(iris, aes(Sepal.Width, Sepal.Length)) +
  geom_point() +
  facet_wrap(~ Species)

p + dark_theme_gray()  # geom defaults changed

p + theme_gray()  # oh no! geoms are not visible on light background

invert_geom_defaults()  # geom defaults changed back

p + theme_gray() # back to normal
}
