% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlight.R
\name{highlight_spec}
\alias{highlight_spec}
\title{Highlight Specification}
\usage{
highlight_spec(what, highlight_color = NULL, other_color = NULL)
}
\arguments{
\item{what}{\code{character} The value(s) to highlight}

\item{highlight_color}{\code{character} The highlight color(s)}

\item{other_color}{\code{character} The color for the non-highlighted values}
}
\value{
An object of class \code{ggcharts_highlight_spec}
}
\description{
Create a highlight specification to pass on to a chart function
}
\details{
\code{highlight_color} must be of length 1 or the same length as \code{what}. If it is of
length 1 then all values in \code{what} are highlighted with the same color.

If \code{highlight_color} is \code{NULL} (the default) then it is set to the default
color of the currently active \code{ggcharts} theme, i.e. \code{ggcharts_get_default_color(ggcharts_get_theme())}.

If \code{other_color} is \code{NULL} is is automatically determined from the background
color of the currently active \code{ggcharts} theme.
}
\examples{
data("biomedicalrevenue")
revenue2018 <- biomedicalrevenue[biomedicalrevenue$year == 2018, ]

spec <- highlight_spec("Bayer")
bar_chart(revenue2018, company, revenue, highlight = spec)

spec <- highlight_spec("Bayer", "black", "gray")
bar_chart(revenue2018, company, revenue, highlight = spec)

spec <- highlight_spec(c("Bayer", "Novartis"))
bar_chart(revenue2018, company, revenue, highlight = spec)

spec <- highlight_spec(c("Bayer", "AstraZeneca"), c("darkgreen", "darkorange"))
bar_chart(revenue2018, company, revenue, highlight = spec)

ggcharts_set_theme("theme_ng")
spec <- highlight_spec("Novartis")
lollipop_chart(revenue2018, company, revenue, highlight = spec)

}
\author{
Thomas Neitmann
}
