% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dark_mode.R
\name{dark_mode_t}
\alias{dark_mode_t}
\title{Dark mode theme with top legend}
\usage{
dark_mode_t(
  base_size = 11,
  base_family = "",
  base_colour = "#c8d7dfff",
  axis_line_colour = "#121b24ff",
  axis_line_linewidth = 0.33,
  axis_ticks_colour = axis_line_colour,
  axis_ticks_linewidth = axis_line_linewidth,
  axis_ticks_length_x = grid::unit(base_size/3, "pt"),
  axis_ticks_length_y = grid::unit(base_size/4, "pt"),
  panel_grid_colour = "#00040aff",
  panel_grid_linewidth = 1.33,
  panel_background_fill = "#050d1bff",
  plot_background_fill = "#00040aff",
  legend_axis_line_colour = plot_background_fill,
  legend_axis_line_linewidth = 0.33,
  legend_background_fill = plot_background_fill,
  legend_key_fill = plot_background_fill,
  legend_ticks_colour = legend_axis_line_colour,
  legend_ticks_linewidth = legend_axis_line_linewidth,
  legend_ticks_length = ggplot2::rel(c(0.175, 0)),
  orientation = NULL,
  ...
)
}
\arguments{
\item{base_size}{The base size of the text theme element. Defaults to 11.}

\item{base_family}{The base family of the text theme element. Defaults to "".}

\item{base_colour}{The base colour of the text theme element.}

\item{axis_line_colour}{The colour of the axis.line theme element.}

\item{axis_line_linewidth}{The linewidth of the axis.line theme element.}

\item{axis_ticks_colour}{The colour of the axis.ticks theme element.}

\item{axis_ticks_linewidth}{The linewidth of the axis.ticks theme element.}

\item{axis_ticks_length_x}{The length of the axis.ticks.length.x theme element.}

\item{axis_ticks_length_y}{The length of the axis.ticks.length.y theme element.}

\item{panel_grid_colour}{The colour of the panel.grid theme element.}

\item{panel_grid_linewidth}{The linewidth of the panel.grid theme element.}

\item{panel_background_fill}{The fill (and colour) of the panel.background theme element.}

\item{plot_background_fill}{The fill (and colour) of the plot.background theme element.}

\item{legend_axis_line_colour}{The colour of the legend.axis.line theme element.}

\item{legend_axis_line_linewidth}{The linewidth of the legend.axis.line theme element.}

\item{legend_background_fill}{The fill (and colour) of the legend.background theme element.}

\item{legend_key_fill}{The fill (and colour) of the legend.key theme element.}

\item{legend_ticks_colour}{The colour of the legend.ticks theme element.}

\item{legend_ticks_linewidth}{The linewidth of the legend.ticks theme element.}

\item{legend_ticks_length}{The legend.ticks.length theme element.}

\item{orientation}{The orientation of the plot. Either "x" or "y". Defaults to NULL. Not intended for use with the mode argument of gg_* functions.}

\item{...}{Provided to support trailing commas only.}
}
\value{
A ggplot theme.
}
\description{
Dark mode theme with top legend using \code{darkness} colours.
}
\examples{
library(palmerpenguins)
library(ggplot2)

set_blanket()

penguins |>
  gg_point(
    x = flipper_length_mm,
    y = body_mass_g,
    col = species,
    mode = dark_mode_t()
  )

}
