% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-grob-magick.R
\name{magickGrob}
\alias{magickGrob}
\title{Rasterize a grob object with magick}
\usage{
magickGrob(
  grob,
  magick = NULL,
  ...,
  res = NULL,
  interpolate = FALSE,
  name = NULL,
  vp = NULL
)
}
\arguments{
\item{grob}{A \code{\link[grid:grid.grob]{grob()}}. Use \code{\link[=patch]{patch()}} to convert any objects
into a \code{grob}.}

\item{magick}{A function (purrr-style formula is accepted) that takes an
\code{\link[magick:editing]{image_read()}} object as input and returns an object
compatible with \code{\link[grDevices:as.raster]{as.raster()}}. You can use any of
the \verb{image_*()} functions from the \strong{magick} package to process the raster
image.}

\item{...}{These dots are for future extensions and must be empty.}

\item{res}{An integer sets the desired resolution in pixels.}

\item{interpolate}{
    A logical value indicating whether to linearly interpolate the
    image (the alternative is to use nearest-neighbour interpolation,
    which gives a more blocky result).
  }

\item{name}{ A character identifier. }

\item{vp}{A Grid viewport object (or NULL).}
}
\value{
A \code{magickGrob} object.
}
\description{
Rasterize a grob object with magick
}
