% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify-matrix-maftools.R
\name{fortify_matrix.GISTIC}
\alias{fortify_matrix.GISTIC}
\title{Build a matrix from a maftools object}
\usage{
\method{fortify_matrix}{GISTIC}(
  data,
  ...,
  n_top = NULL,
  bands = NULL,
  ignored_bands = NULL,
  sample_anno = NULL,
  remove_empty_samples = TRUE,
  data_arg = NULL,
  call = NULL
)
}
\arguments{
\item{data}{A \code{\link[maftools:readGistic]{GISTIC}} object.}

\item{...}{These dots are for future extensions and must be empty.}

\item{n_top}{A single number indicates how many top bands to be drawn.}

\item{bands}{An atomic character defines the bands to draw.}

\item{ignored_bands}{An atomic character defines the bands to be ignored.}

\item{sample_anno}{A data frame of sample clinical features to be added.}

\item{remove_empty_samples}{A single boolean value indicating whether to drop
samples without any genomic alterations.}

\item{data_arg}{The argument name for \code{data}. Developers can use it to
improve messages. Not used by the user.}

\item{call}{The execution environment where \code{data} and other arguments for
the method are collected. Developers can use it to improve messages. Not
used by the user.}
}
\description{
Build a matrix from a maftools object
}
\section{ggalign attributes}{

\itemize{
\item \code{sample_anno}: sample clinical informations provided in \code{sample_anno}.
\item \code{sample_summary}: sample copy number summary informations. See
\code{data@cnv.summary} for details.
\item \code{cytoband_summary}: cytoband summary informations. See
\code{data@cytoband.summary} for details.
\item \code{gene_summary}: gene summary informations. See
\code{data@gene.summary} for details.
\item \code{summary}: A data frame of summary information. See \code{data@summary} for
details.
}
}

\seealso{
Other \code{\link[=fortify_matrix]{fortify_matrix()}} methods:
\code{\link{fortify_matrix.MAF}()},
\code{\link{fortify_matrix.default}()},
\code{\link{fortify_matrix.list_upset}()},
\code{\link{fortify_matrix.matrix}()},
\code{\link{fortify_matrix.matrix_oncoplot}()},
\code{\link{fortify_matrix.matrix_upset}()},
\code{\link{fortify_matrix.phylo}()}
}
\concept{fortify_matrix}
