% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial.rfsrc.R
\name{partial.rfsrc}
\alias{partial.rfsrc}
\title{randomForestSRC partial dependence (data object) (modified from randomForestSRC V1.6.0)}
\usage{
partial.rfsrc(x, xvar.names, which.outcome, surv.type = c("mort", "rel.freq",
  "surv", "years.lost", "cif", "chf"), nvar, npts = 25, subset, granule = 5,
  ...)
}
\arguments{
\item{x}{An object of class (\code{rfsrc}, \code{grow}), (\code{rfsrc}, \code{synthetic}), 
(\code{rfsrc}, \code{predict}).}

\item{xvar.names}{Names of the x-variables to be used.}

\item{which.outcome}{For classification families, an integer or character value specifying 
the class to focus on (defaults to the first class). For competing risk families, an integer 
value between 1 and J indicating the event of interest, where J is the number of event types. 
The default is to use the first event type.}

\item{surv.type}{For survival families, specifies the predicted value. See details below.}

\item{nvar}{Number of variables to be plotted. Default is all.}

\item{npts}{Maximum number of points used when generating partial plots for continuous variables.}

\item{subset}{Vector indicating which rows of the x-variable matrix x$xvar to use. All rows are 
used if not specified.}

\item{granule}{Integer value controlling minimum number of unique values required to treat a 
variable as continuous. If there are fewer, the variable is treated as a factor}

\item{...}{other used arguments. Included for compatibility with plot.variable calls.}
}
\description{
calculate the partial dependence of an x-variable on the class probability 
(classification), response (regression), mortality (survival), or the expected years lost 
(competing risk) from a RF-SRC analysis.
}
\details{
The vertical axis displays the ensemble predicted value, while x-variables are plotted on the 
horizontal axis. 
\enumerate{
 \item For regression, the predicted response is used.
\item For classification, it is the predicted class probability specified by which.outcome.

\item For survival, the choices are:
 \itemize{ 
\item  Mortality (mort).
\item  Relative frequency of mortality (rel.freq).
\item  Predicted survival (surv)
}

\item  For competing risks, the choices are:
\itemize{
\item    The expected number of life years lost (years.lost).
\item  The cumulative incidence function (cif).
\item  The cumulative hazard function (chf).
}
In all three cases, the predicted value is for the event type specified by which.outcome.
}

The y-value for a variable X, evaluated at \eqn{X=x}, is

\deqn{\tilde{f}(x) = \frac{1}{n} \sum_{i=1}^n \hat{f}(x, x_{i,o}),}
where \eqn{x_{i,o}} represents the value for all other variables other than \eqn{X} for individual \eqn{i} and
 \eqn{\hat{f}} is the predicted value. Generating partial plots can be very slow. Choosing a small 
 value for npts can speed up computational times as this restricts the number of distinct x 
 values used in computing \eqn{\tilde{f}}.

Calculating partial dependence data can be slow. Setting npts to a smaller number can help.
}
\examples{
## ------------------------------------------------------------
## survival/competing risk
## ------------------------------------------------------------

## survival
\dontrun{
data(veteran, package = "randomForestSRC")
v.obj <- rfsrc(Surv(time,status)~., veteran, nsplit = 10, ntree = 100)
plot.variable(v.obj, plots.per.page = 3)
plot.variable(v.obj, plots.per.page = 2, xvar.names = c("trt", "karno", "age"))
plot.variable(v.obj, surv.type = "surv", nvar = 1)
plot.variable(v.obj, surv.type = "surv", partial = TRUE, smooth.lines = TRUE)
plot.variable(v.obj, surv.type = "rel.freq", partial = TRUE, nvar = 2)

## example of plot.variable calling a pre-processed plot.variable object
p.v <- plot.variable(v.obj, surv.type = "surv", partial = TRUE, smooth.lines = TRUE)
plot.variable(p.v)
p.v$plots.per.page <- 1
p.v$smooth.lines <- FALSE
plot.variable(p.v)
}
\dontrun{
## competing risks
data(follic, package = "randomForestSRC")
follic.obj <- rfsrc(Surv(time, status) ~ ., follic, nsplit = 3, ntree = 100)
plot.variable(follic.obj, which.outcome = 2)
}
## ------------------------------------------------------------
## regression
## ------------------------------------------------------------
\dontrun{
## airquality
airq.obj <- rfsrc(Ozone ~ ., data = airquality)
plot.variable(airq.obj, partial = TRUE, smooth.lines = TRUE)
## motor trend cars
mtcars.obj <- rfsrc(mpg ~ ., data = mtcars)
plot.variable(mtcars.obj, partial = TRUE, smooth.lines = TRUE)
}
## ------------------------------------------------------------
## classification
## ------------------------------------------------------------

## iris
#rfsrc_iris <- rfsrc(Species ~., data = iris)
data(rfsrc_iris, package="ggRandomForests")
#gg_dta <- partial.rfsrc(rfsrc_iris, )

\dontrun{
## motor trend cars: predict number of carburetors
mtcars2 <- mtcars
mtcars2$carb <- factor(mtcars2$carb,
                       labels = paste("carb", sort(unique(mtcars$carb))))
mtcars2.obj <- rfsrc(carb ~ ., data = mtcars2)
plot.variable(mtcars2.obj, partial = TRUE)
}


}
\author{
Hemant Ishwaran and Udaya B. Kogalur (Modified by John Ehrlinger)
}
\references{
Friedman J.H. (2001). Greedy function approximation: a gradient boosting machine, Ann. of Statist., 5:1189-1232.

Ishwaran H., Kogalur U.B. (2007). Random survival forests for R, Rnews, 7(2):25-31.

Ishwaran H., Kogalur U.B., Blackstone E.H. and Lauer M.S. (2008). Random survival forests, Ann. App. Statist., 2:841-860.

Ishwaran H., Gerds T.A., Kogalur U.B., Moore R.D., Gange S.J. and Lau B.M. (2014). Random survival forests for competing risks. 
To appear in Biostatistics.
}
\seealso{
\code{rfsrc}, \code{rfsrcSyn}, \code{predict.rfsrc}
}

