% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/print.gg_error.R
\name{print.gg_error}
\alias{print.gg_error}
\title{Print a \code{\link{gg_error}} object.}
\usage{
\method{print}{gg_error}(x, ...)
}
\arguments{
\item{x}{a \code{\link{gg_error}} object.}

\item{...}{optional arguments

We use the tble_df command to print \code{gg_error} objects because they
tend to be long (ntree records long).}
}
\description{
Print a \code{\link{gg_error}} object.
}
\examples{
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
## You can build a randomForest
# rfsrc_iris <- rfsrc(Species ~ ., data = iris)
# ... or load a cached randomForestSRC object
data(rfsrc_iris, package="ggRandomForests")

# Get a data.frame containing minimaldepth measures
gg_dta<- gg_error(rfsrc_iris)
print(gg_dta)

## ------------------------------------------------------------
## regression example
## ------------------------------------------------------------
data(rfsrc_airq, package="ggRandomForests")

# Get a data.frame containing minimaldepth measures
gg_dta<- gg_error(rfsrc_airq)
print(gg_dta)
}
\seealso{
\code{rfsrc} \code{tbl_df} \code{\link{gg_error}}
}

