% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.gg_vimp}
\alias{plot.gg_vimp}
\title{Plot a \code{\link{gg_vimp}} object, extracted variable importance of a
\code{randomForestSRC::rfsrc} object}
\usage{
\method{plot}{gg_vimp}(x, n_var, barcolor, label, relative, ...)
}
\arguments{
\item{x}{\code{\link{gg_vimp}} object created from a \code{randomForestSRC::rfsrc} object}

\item{n_var}{restrict the plot to only nvar variable importance measures}

\item{barcolor}{Vector of booleans to color vimp bars. By default the "positive" column, TRUE-> "blue".}

\item{label}{A vector of alternative variable names.}

\item{relative}{should we plot vimp or relative vimp. Defaults to vimp.}

\item{...}{optional arguments passed to gg_vimp if necessary}
}
\value{
\code{ggplot} object
}
\description{
Plot a \code{\link{gg_vimp}} object, extracted variable importance of a
\code{randomForestSRC::rfsrc} object
}
\examples{
\dontrun{
#' ## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
# iris_rf <- rfsrc(Species ~ ., data = iris)
data(iris_rf, package="ggRandomForests")
ggrf <- gg_vimp(iris_rf)
plot(ggrf)

## ------------------------------------------------------------
## regression example
## ------------------------------------------------------------

# airq.obj <- rfsrc(Ozone ~ ., airquality)
data(airq_rf, package="ggRandomForests")
ggrf <- gg_vimp(airq_rf)
plot(ggrf)

## ------------------------------------------------------------
## survival example
## ------------------------------------------------------------
data(veteran_rf, package="ggRandomForests")
ggrf <- gg_vimp(veteran_rf)
plot(ggrf)
}
}
\references{
Breiman L. (2001). Random forests, Machine Learning, 45:5-32.

Ishwaran H. and Kogalur U.B. (2007). Random survival forests for
R, Rnews, 7(2):25-31.

Ishwaran H. and Kogalur U.B. (2013). Random Forests for Survival,
Regression and Classification (RF-SRC), R package version 1.4.
}
\seealso{
\code{\link{gg_vimp}}
}

