% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.gg_minimal_depth}
\alias{plot.gg_minimal_depth}
\title{Plot a \code{\link{gg_minimal_depth}} object for random forest variable ranking.}
\usage{
\method{plot}{gg_minimal_depth}(x, selection = FALSE, list_vars = TRUE,
  type = c("named", "rank"), ...)
}
\arguments{
\item{x}{\code{\link{gg_minimal_depth}} object created from a \code{randomForestSRC::rfsrc} object}

\item{selection}{should we restrict the plot to only include variables selected by the
minimal depth criteria (boolean).}

\item{list_vars}{add text list of ranked variables. Only used if selection = TRUE (boolean)}

\item{type}{select type of y axis labels c("named","rank")}

\item{...}{optional arguments passed to \code{\link{gg_minimal_depth}}}
}
\value{
\code{ggplot} object
}
\description{
Plot a \code{\link{gg_minimal_depth}} object for random forest variable ranking.
}
\examples{
\dontrun{
#' ## Examples from RFSRC package...
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
## You can build a randomForest
# iris_rf <- rfsrc(Species ~ ., data = iris)
# iris_vs <- var.select(iris_rf)
# ... or load a cached randomForestSRC object
data(iris_vs, package="ggRandomForests")

# Get a data.frame containing minimaldepth measures
ggrf.obj<- gg_minimal_depth(iris_vs)

# Plot the gg_mkinimal_depth object
plot(ggrf.obj)

## ------------------------------------------------------------
## Regression example
## ------------------------------------------------------------
# airq_rf <- rfsrc(Ozone ~ ., data = airquality, na.action = "na.impute")
# airq_vs <- var.select(airq_rf)
# ... or load a cached randomForestSRC object
data(airq_vs, package="ggRandomForests")

# Get a data.frame containing error rates
ggrf.obj<- gg_minimal_depth(airq_vs)

# Plot the gg_error object
plot(ggrf.obj)

## ------------------------------------------------------------
## Survival example
## ------------------------------------------------------------
## veteran data
## randomized trial of two treatment regimens for lung cancer
# data(veteran, package = "randomForestSRC")
# veteran_rf <- rfsrc(Surv(time, status) ~ ., data = veteran, ntree = 100)
# veteran_vs <- var.select(veteran_rf)
# Load a cached randomForestSRC object
data(veteran_vs, package="ggRandomForests")

ggrf.obj <- gg_minimal_depth(veteran_vs)
plot(ggrf.obj)

}
}
\references{
Breiman L. (2001). Random forests, Machine Learning, 45:5-32.

Ishwaran H. and Kogalur U.B. (2007). Random survival forests for R,
Rnews, 7(2):25-31.

Ishwaran H. and Kogalur U.B. (2014). Random Forests for Survival,
Regression and Classification (RF-SRC), R package version 1.5.
}
\seealso{
\code{randomForestSRC::var.select} \code{\link{gg_minimal_depth}}
}

