% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-residual.R
\name{residual}
\alias{residual}
\title{This function create a residual for each observed value and also generates a residual
distribution}
\usage{
residual(
  x,
  y,
  labels = NULL,
  point = NULL,
  is.hline = FALSE,
  hline = NULL,
  dname = NULL,
  facets = NULL,
  bloq = NULL,
  ...
)
}
\arguments{
\item{x}{x axis aesthetics}

\item{y}{y axis aesthetics}

\item{labels}{list that contain title,subtitle, axis labels}

\item{point}{geom point graphical parameters}

\item{is.hline}{logical if TRUE add horizontal line y=0 ( TRUE by default)}

\item{hline}{geom hline graphical parameters}

\item{dname}{name of dataset to be used}

\item{facets}{\code{list} wrap facetting in case of strat.facet}

\item{bloq}{\code{pmxBLOQ} object created by \code{\link{pmx_bloq}}}

\item{...}{others graphics arguments passed to \code{\link{pmx_gpar}} internal object.}
}
\value{
a residual object
}
\description{
This function create a residual for each observed value and also generates a residual
distribution
}
\details{
Some parameters are a list of parameters :

\strong{point} is a list that contains:
\itemize{
\item {\strong{shape:}} {default to 1}
\item {\strong{color:}} {default to black}
\item {\strong{size:}} {default to 1}
}

\strong{labels} is a list that contains:
\itemize{
\item {\strong{title:}} {plot title default to AES_X versue AES_Y}
\item {\strong{subtitle:}} {plot subtitle default empty}
\item {\strong{x:}} {x axis label default to AES_X}
\item {\strong{y:}} {y axis label default to AES_Y}
}
}
\seealso{
\code{\link{plot_pmx.residual}}
}
