% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmx-plots-individual.R
\name{pmx_plot_individual}
\alias{pmx_plot_individual}
\title{Individual plot}
\usage{
pmx_plot_individual(ctr, npage = 1, print = FALSE, dname, pred_line,
  ipred_line, point, is.legend, use.finegrid, bloq, filter, strat.facet, facets,
  strat.color, trans, pmxgpar, labels, axis.title, axis.text, ranges, is.smooth,
  smooth, is.band, band, is.draft, draft, is.identity_line, identity_line,
  scale_x_log10, scale_y_log10, color.scales, ...)
}
\arguments{
\item{ctr}{pmx controller}

\item{npage}{\code{integer} page(s) to display , set npage to NULL}

\item{print}{\code{logical} if TRUE the ouptut will be a print not a ggplot2. This
is useful for rmarkdwon output to avoid verbose list index print.}

\item{dname}{\code{character} name of dataset to be used. User can create his own
dataset using \code{\link{set_data}} and pass it as dname to be plotted.}

\item{pred_line}{\code{list} some ipred line geom properties aesthetics}

\item{ipred_line}{\code{list} some pred line geom properties aesthetics}

\item{point}{\code{list} some point geom properties aesthetics}

\item{is.legend}{\code{logical} if TRUE add a legend}

\item{use.finegrid}{\code{logical} if FALSE use predictions data set}

\item{bloq}{\code{pmxBLOQ} object created by \code{\link{pmx_bloq}}.

\strong{pmx_update parameters}}

\item{filter}{\code{expression} filter which will be applied to plotting data.}

\item{strat.facet}{\code{formula} optional stratification parameter by facetting.
This split plot by strats(each strat in a facet)}

\item{facets}{\code{list} facet_wrap parameters.}

\item{strat.color}{\code{character} optional stratification parameter by grouping.
This will split the plot by group (color) of strat.}

\item{trans}{\code{character} define the transformation to apply on x or y or both variables}

\item{pmxgpar}{a object of class pmx_gpar possibly the output of the

\strong{pmx_gpar: Shared basic graphics parameters}}

\item{labels}{\code{list} list containing plot and/or axis labels: title, subtitle, x , y}

\item{axis.title}{\code{list} containing element_text attributes to customize
the axis title. (similar to ggplot2 axis.title theme)}

\item{axis.text}{\code{list} containing element_text attributes to customize
the axis text (similar to ggplot2 axis.text theme)}

\item{ranges}{\code{list} limits of x/y ranges}

\item{is.smooth}{\code{logical} if set to TRUE add smooth layer}

\item{smooth}{\code{list} geom_smooth graphical/smoothing fun parameters}

\item{is.band}{\code{logical} if TRUE add horizontal band}

\item{band}{\code{list} horizontal band parameters. geom_hline graphical parameters.}

\item{is.draft}{\code{logical} if TRUE add draft layer}

\item{draft}{\code{list} draft layer parameters. geom_text graphical parameters.}

\item{is.identity_line}{\code{logical} if TRUE add an identity line}

\item{identity_line}{\code{list}geom_abline graphical parameters.}

\item{scale_x_log10}{\code{logical} if TRUE use log10 scale for x axis.}

\item{scale_y_log10}{\code{logical} if TRUE use log10 scale for y axis.}

\item{color.scales}{\code{list} define scales parameter in case of strat.color \code{\link{pmx_settings}}}

\item{...}{others graphics parameters passed :
\itemize{
\item \code{\link{pmx_gpar}} internal function to customize shared graphical parameters
\item \code{\link{individual}} generic object for individual plots.
\item \code{\link{pmx_update}} function.
}
\strong{individual parameters}}
}
\value{
ggplot2 or list of ggplot2 objects
}
\description{
Individual plot
}
\examples{
# basic use  ---------------------------------------
\donttest{
ctr <- theophylline()
ctr \%>\% pmx_plot_individual(npage = 1)
## multiple pages
ctr \%>\% pmx_plot_individual(npage = c(1, 3))
## change faceting
ctr \%>\% pmx_plot_individual(facets = list(nrow = 5, ncol = 5), npage = 2)


# update graphical parameter  ----------------------

## update labels
ctr \%>\% pmx_plot_individual(
  labels = list(title = "Custom individual plot")
)

## remove draft
ctr \%>\% pmx_plot_individual(is.draft = FALSE)

## Customize ipred_line with any geom_line parameter
ctr \%>\% pmx_plot_individual(
  pred_line = list(color = "red", linetype = 20, alpha = 0.5)
)

## Customize ipred_line with any geom_line parameter
ctr \%>\% pmx_plot_individual(
  ipred_line = list(size = 5)
)


## Customize any geom_point parameter
ctr \%>\% pmx_plot_individual(
  point = list(aes(alpha = DV), color = "green", shape = 4)
)


## legend

p <- ctr \%>\% pmx_plot_individual(
  is.legend=TRUE,
  point=list(shape=20),
  pred_line=list(linetype=6),
  pred_line=list(linetype=3)
)

# # stratification  ----------------------------------
#
# ## continuous stratification
ctr \%>\% pmx_plot_individual(strat.color = "WT0")

# # subsetting  --------------------------------------
#
# ## we can use any expression involving the data
# ## filter and stratify
ctr \%>\% pmx_plot_individual(
  filter = SEX == 1, strat.facet = ~SEX, 
  facets = list(nrow = 5, ncol = 5))

# # transformation  --------------------------------------
#
# ## apply a log transformation in y
ctr \%>\% pmx_plot_individual(trans = "log10_y")
# ## apply a custonm trsnformation to normalize axis between 0 and 1

## get a list of parameter
p <- ctr \%>\% pmx_plot_individual(
  npage=NULL,
  point=list(shape=4,color='blue',size=10),
  facets = list(nrow = 5, ncol = 5),
  labels = list(title = "My individuals",x='my time',y='PD data')
) 

}
}
