% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clip_shapefile.R
\name{clip_shapefile}
\alias{clip_shapefile}
\title{Clip a shapefile using a bounding area}
\usage{
clip_shapefile(
  x,
  limits,
  proj.limits = 4326,
  simplify = FALSE,
  tol = 60,
  return.boundary = FALSE,
  extra.validate = FALSE
)
}
\arguments{
\item{x}{Original shapefile to be clipped as a an \link[sf]{sf} or \code{sp} polygons object. Required. Must contain \code{\link[sf:st_crs]{CRS}} information.}

\item{limits}{The constraining area used to clip \code{x}. Required. Either a numeric vector of length 4 or a spatial object from the sf or sp packages. The first element of the numeric vector defines the minimum longitude, second element the maximum longitude, third element the minimum latitude and fourth element the maximum latitude of the bounding box. If a spatial object, it must contain \code{\link[sf:st_crs]{CRS}} information. See details.}

\item{proj.limits}{The \code{\link[sf:st_crs]{CRS}} projection attributes for \code{limits}. Hence format accepted by \code{\link[sf]{st_crs}} will suffice but integers are the easiest. Defaults to decimal degrees.}

\item{simplify}{Should the \code{x} geometry be simplified before clipping? Useful to make the function faster for large shape files. Uses \code{\link[sf]{st_simplify}} function.}

\item{tol}{Numerical tolerance value to be used for simplification. See \code{?sf::st_simplfy}.}

\item{return.boundary}{Logical. If \code{TRUE} returns the clip boundary together with the shapefile.}

\item{extra.validate}{Logical indicating whether \code{x} should be run through extra validation. Slows down the function but is necessary in some cases involving anti-meridian.}
}
\value{
Clipped spatial object. If \code{return.boundary = TRUE}, a list containing the shapefile together with the clip boundary.
}
\description{
Clips an area from a larger shapefile provided in sf or sp formats.
}
\details{
The function uses the \code{\link[sf]{st_intersection}} function to clip smaller polygons from larger ones. The clip area is constrained by either a numeric vector or a spatial object in the \code{limits} argument. Defining \code{limits} by a \code{\link[sf:st_sf]{sf}} object gives greater freedom for the clip area as the area does not have to be rectangular.
}
\seealso{
Other create shapefiles: 
\code{\link{geonorge_bathymetry}()},
\code{\link{raster_bathymetry}()},
\code{\link{vector_bathymetry}()}
}
\author{
Mikko Vihtakari
}
\concept{create shapefiles}
\keyword{internal}
