% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3methods.R
\name{print.gformula_binary_eof}
\alias{print.gformula_binary_eof}
\title{Print method for objects of class "gformula_binary_eof"}
\usage{
\method{print}{gformula_binary_eof}(x, coefficients = FALSE,
  stderrs = FALSE, rmses = FALSE, ...)
}
\arguments{
\item{x}{Object of class "gformula_binary_eof".}

\item{coefficients}{Logical scalar indicating whether to  print the model coefficients. The default is \code{FALSE}.}

\item{stderrs}{Logical scalar indicating whether to print the standard error of the model coefficients. The default is \code{FALSE}.}

\item{rmses}{Logical scalar indicating whether to print the model root mean square errors (RMSEs). The default is \code{FALSE}.}

\item{...}{Other arguments.}
}
\value{
No value is returned.
}
\description{
Print method for objects of class "gformula_binary_eof".
}
\examples{
## Estimating the effect of threshold interventions on the mean of a binary
## end of follow-up outcome
\donttest{
id <- 'id_num'
time_name <- 'time'
covnames <- c('cov1', 'cov2', 'treat')
outcome_name <- 'outcome'
histories <- c(lagged, cumavg)
histvars <- list(c('treat', 'cov1', 'cov2'), c('cov1', 'cov2'))
covtypes <- c('binary', 'zero-inflated normal', 'normal')
covparams <- list(covmodels = c(cov1 ~ lag1_treat + lag1_cov1 + lag1_cov2 + cov3 +
                                  time,
                                cov2 ~ lag1_treat + cov1 + lag1_cov1 + lag1_cov2 +
                                  cov3 + time,
                                treat ~ lag1_treat + cumavg_cov1 +
                                  cumavg_cov2 + cov3 + time))
ymodel <- outcome ~  treat + cov1 + cov2 + lag1_cov1 + lag1_cov2 + cov3
intvars <- list('treat', 'treat')
interventions <- list(list(c(static, rep(0, 7))),
                      list(c(threshold, 1, Inf)))
int_descript <- c('Never treat', 'Threshold - lower bound 1')
nsimul <- 10000
ncores <- 2

gform_bin_eof <- gformula_binary_eof(obs_data = binary_eofdata, id = id,
                                     time_name = time_name,
                                     covnames = covnames,
                                     outcome_name = outcome_name,
                                     covtypes = covtypes,
                                     covparams = covparams,
                                     ymodel = ymodel,
                                     intvars = intvars,
                                     interventions = interventions,
                                     int_descript = int_descript,
                                     histories = histories, histvars = histvars,
                                     basecovs = c("cov3"), seed = 1234,
                                     parallel = TRUE, nsamples = 5,
                                     nsimul = nsimul, ncores = ncores)
print(gform_bin_eof)
}

}
\seealso{
\code{\link{gformula_binary_eof}}
}
