% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s4_architecture.R
\docType{class}
\name{RCurve-class}
\alias{RCurve-class}
\title{RCurve Class for defining recruitment distributions}
\description{
This class extends the Curve class, adding recruitment-related quantities such as patient numbers.
}
\section{Slots}{

\describe{
\item{\code{N}}{Total number of patients recruited.}

\item{\code{Nactive}}{Number of patients recruited in active arm. Nactive+Ncontrol=N.}

\item{\code{Ncontrol}}{Number of patients recruited in control arm. Nactive+Ncontrol=N.}

\item{\code{Ratio}}{Randomisation ratio. Nactive divided by Ncontrol = Ratio.}

\item{\code{Length}}{Total length of the recruitment period.}

\item{\code{RF}}{Name of the random generator function describing the Curve.}

\item{\code{inverse}}{Name of the inverse CDF function describing the Curve. Optional; set to NULL if unavailable.}

\item{\code{paramno}}{Number of parameters required to define the distribution.}

\item{\code{pnames}}{Names of parameters defining the distribution. Should be a vector of length paramno.}

\item{\code{pnames}}{Values of parameters defining the distribution. Should be a list of length paramno.}

\item{\code{maxF}}{Maximum length of patient follow-up. Typically should be Inf.}
}}

\examples{
new("RCurve", type="ExampleCurve",PDF="pdf_fn_name", CDF="CDF_fn_name",
  RF="random_draw_fn_name", inverse="inv_fn_name", paramno=2, pnames=c('param1','param2'),
  pvalue=list(1,2), 
N=100,Nactive=50,Ncontrol=40, Ratio=50/40, Length = 5, maxF = Inf)
}
\author{
James Bell
}
