% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_constructors.R
\name{PieceR}
\alias{PieceR}
\title{PieceR RCurve constructor function}
\usage{
PieceR(recruitment, ratio)
}
\arguments{
\item{recruitment}{2-column matrix with recruitment parameters. First column gives the lengths of each period of recruitment. Second column gives the corresponding rates of recruitment for each period.}

\item{ratio}{Randomisation ratio; active arm divided by control arm.}
}
\description{
This creates a RCurve object for a piecewise-linear recruitment distribution.\cr
RCurve objects contain all necessary information to describe a recruitment distribution. They are a particular type of Curve object containing additional recruitment-related information, including patient numbers and the randomisation ratio.\cr
}
\details{
This RCurve is used when it is expected that patients enter a trial at a constant rate until the required number is achieved.
}
\examples{
rmatrix <- matrix(c(rep(4,3),5,10,15),ncol=2)
rmatrix
PieceR(rmatrix,1)
}
\author{
James Bell
}
