% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_gerbil.R
\name{print.cor_gerbil}
\alias{print.cor_gerbil}
\title{Prints a \code{cor_gerbil} object. Printed output includes the average difference of correlations, as well as summaries of the test statistics based on Fisher's z and their p-values.}
\usage{
\method{print}{cor_gerbil}(x, ...)
}
\arguments{
\item{x}{object of \code{cor_gerbil} class}

\item{...}{additional parameters to be passed down to inner functions.}
}
\value{
The functions \code{print.cor_gerbil} and \code{summary.cor_gerbil} display information 
  about the \code{cor_gerbil} object. The output displayed includes: 
  1) the average absolute difference in correlation between observed and imputed cases across all relevant variable pairs,
  2) the average value of the test statistic based on Fisher's z across all variable pairs,
  3) the largest test statistic observed across any variable pair, and
  4) the portion of p-values for the test based on Fisher's z that are less than 0.05.
}
\description{
Prints a \code{cor_gerbil} object. Printed output includes the average difference of correlations, as well as summaries of the test statistics based on Fisher's z and their p-values.
}
