% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directional.R
\name{Rbar2kappa}
\alias{Rbar2kappa}
\title{\eqn{\bar{R}} to \eqn{\kappa} conversion}
\usage{
Rbar2kappa(R, p = 1)
}
\arguments{
\item{R}{a scalar or vector of values between 0 and 1}

\item{p}{the number of parameters}
}
\value{
value(s) between 0 and \eqn{+\infty}
}
\description{
Converts the empirical concentration parameter
    \eqn{\bar{R}} to the von-Mises concentration parameter
    \eqn{\kappa}.
}
\details{
\eqn{\bar{R}} and \eqn{\kappa} are two types of
    concentration parameter that are commonly used in directional
    data analysis.  \eqn{\kappa} is one of the parameters of the
    parametric von Mises distribution, which is difficult to
    estimate from the data. \eqn{\bar{R}} is easier to calculate
    from data. \code{Rbar2kappa} converts \eqn{\bar{R}} to
    \eqn{\bar{\kappa}} using the following approximate empirical
    formula:

\eqn{\kappa =
    \frac{\bar{R}(p+1-\bar{R}^2)}{1-\bar{R}^2}
}

where \eqn{p} marks the number of parameters in the data space (1
for circle, 2 for a sphere).
}
\examples{
data(striations,package='geostats')
Rbar2kappa(Rbar(striations,degrees=TRUE))
}
\references{
Banerjee, A., et al. ``Clustering on the unit
    hypersphere using von Mises-Fisher distributions.''  Journal of
    Machine Learning Research 6.Sep (2005): 1345-1382.
}
