% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting.R
\name{fit_poisson_model}
\alias{fit_poisson_model}
\title{Fit a Penalized Spline Poisson Model on a Geometric Network}
\usage{
fit_poisson_model(data, Z, K, ind, verbose = FALSE, control = list())
}
\arguments{
\item{data}{The binned data.}

\item{Z}{The (sparse) model matrix where the number of columns must
correspond to the length of the vector of model coefficients \code{theta}.}

\item{K}{A (sparse) square penalty matrix of with the same dimension as
\code{theta}.}

\item{ind}{A list which contains the indices belonging to each smooth term
and the linear terms.}

\item{verbose}{If \code{TRUE}, prints information on the process of the fitting
algorithm.}

\item{control}{A list of optional arguments which control the convergence
of the fitting algorithm. See "Details".}
}
\value{
Model fit.
}
\description{
\code{fit_poisson_model} is called from \code{\link[geonet]{intensity_pspline}}
and performs the iterative algorithm to estimate the model parameters and the
smoothing parameters \eqn{rho} in the penalized Poisson model.
}
\details{
Smoothing parameters are estimated using the generalized Fellner-Schall
method (Wood and Fasiolo, 2017).
}
\references{
Wood, S. N. and Fasiolo, M. (2017). A generalized Fellner-Schall
method for smoothing parameter optimization with application to
Tweedie location, scale and shape models. Biometrics 73 1071-1081.
}
\author{
Marc Schneble \email{marc.schneble@stat.uni-muenchen.de}
}
