% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GNOpenAPIManager.R
\docType{class}
\name{GNOpenAPIManager}
\alias{GNOpenAPIManager}
\title{GNOpenAPIManager}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for communication with
the REST API of a GeoNetwork instance using the legacy API.
}
\description{
GNOpenAPIManager

GNOpenAPIManager
}
\examples{
\dontrun{
   GNOpenAPIManager$new("http://localhost:8080/geonetwork", "admin", "geonetwork", "4.0.5")
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geonetwork}
\keyword{rest}
\section{Super class}{
\code{\link[geonapi:GNAbstractManager]{geonapi::GNAbstractManager}} -> \code{GNOpenAPIManager}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GNOpenAPIManager-new}{\code{GNOpenAPIManager$new()}}
\item \href{#method-GNOpenAPIManager-login}{\code{GNOpenAPIManager$login()}}
\item \href{#method-GNOpenAPIManager-getGroups}{\code{GNOpenAPIManager$getGroups()}}
\item \href{#method-GNOpenAPIManager-getTags}{\code{GNOpenAPIManager$getTags()}}
\item \href{#method-GNOpenAPIManager-getCategories}{\code{GNOpenAPIManager$getCategories()}}
\item \href{#method-GNOpenAPIManager-getMetadataByUUID}{\code{GNOpenAPIManager$getMetadataByUUID()}}
\item \href{#method-GNOpenAPIManager-insertRecord}{\code{GNOpenAPIManager$insertRecord()}}
\item \href{#method-GNOpenAPIManager-insertMetadata}{\code{GNOpenAPIManager$insertMetadata()}}
\item \href{#method-GNOpenAPIManager-updateMetadata}{\code{GNOpenAPIManager$updateMetadata()}}
\item \href{#method-GNOpenAPIManager-deleteMetadata}{\code{GNOpenAPIManager$deleteMetadata()}}
\item \href{#method-GNOpenAPIManager-uploadAttachment}{\code{GNOpenAPIManager$uploadAttachment()}}
\item \href{#method-GNOpenAPIManager-publishThumbnail}{\code{GNOpenAPIManager$publishThumbnail()}}
\item \href{#method-GNOpenAPIManager-clone}{\code{GNOpenAPIManager$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="ERROR"><a href='../../geonapi/html/GNAbstractManager.html#method-GNAbstractManager-ERROR'><code>geonapi::GNAbstractManager$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="INFO"><a href='../../geonapi/html/GNAbstractManager.html#method-GNAbstractManager-INFO'><code>geonapi::GNAbstractManager$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="WARN"><a href='../../geonapi/html/GNAbstractManager.html#method-GNAbstractManager-WARN'><code>geonapi::GNAbstractManager$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="getClassName"><a href='../../geonapi/html/GNAbstractManager.html#method-GNAbstractManager-getClassName'><code>geonapi::GNAbstractManager$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="getLang"><a href='../../geonapi/html/GNAbstractManager.html#method-GNAbstractManager-getLang'><code>geonapi::GNAbstractManager$getLang()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="getUrl"><a href='../../geonapi/html/GNAbstractManager.html#method-GNAbstractManager-getUrl'><code>geonapi::GNAbstractManager$getUrl()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="logger"><a href='../../geonapi/html/GNAbstractManager.html#method-GNAbstractManager-logger'><code>geonapi::GNAbstractManager$logger()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNOpenAPIManager-new"></a>}}
\if{latex}{\out{\hypertarget{method-GNOpenAPIManager-new}{}}}
\subsection{Method \code{new()}}{
This method is used to instantiate a \code{GNOpenAPIManager} with the \code{url} of the
   GeoNetwork and credentials to authenticate (\code{user}/\code{pwd}).
   
   The \code{keyring_backend} can be set to use a different backend for storing 
   the Geonetwork password/token with \pkg{keyring} (Default value is 'env').
   
   The logger can be either NULL, "INFO" (with minimum logs), or "DEBUG" 
   (for complete curl http calls logs)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNOpenAPIManager$new(
  url,
  user = NULL,
  pwd = NULL,
  version,
  logger = NULL,
  keyring_backend = "env"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{url}

\item{\code{user}}{user}

\item{\code{pwd}}{pwd}

\item{\code{version}}{version}

\item{\code{logger}}{logger}

\item{\code{keyring_backend}}{keyring backend}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNOpenAPIManager-login"></a>}}
\if{latex}{\out{\hypertarget{method-GNOpenAPIManager-login}{}}}
\subsection{Method \code{login()}}{
This methods attempts a connection to GeoNetwork REST API. User internally
   during initialization of \code{GNLegacyAPIManager}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNOpenAPIManager$login(user, pwd)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user}}{user}

\item{\code{pwd}}{pwd}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNOpenAPIManager-getGroups"></a>}}
\if{latex}{\out{\hypertarget{method-GNOpenAPIManager-getGroups}{}}}
\subsection{Method \code{getGroups()}}{
Retrieves the list of user groups available in Geonetwork
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNOpenAPIManager$getGroups()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an object of class \code{data.frame}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNOpenAPIManager-getTags"></a>}}
\if{latex}{\out{\hypertarget{method-GNOpenAPIManager-getTags}{}}}
\subsection{Method \code{getTags()}}{
Retrieves the list of tags (categories) available in Geonetwork
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNOpenAPIManager$getTags()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an object of class \code{data.frame}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNOpenAPIManager-getCategories"></a>}}
\if{latex}{\out{\hypertarget{method-GNOpenAPIManager-getCategories}{}}}
\subsection{Method \code{getCategories()}}{
Retrieves the list of categories (same as tags) available in Geonetwork
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNOpenAPIManager$getCategories()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an object of class \code{data.frame}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNOpenAPIManager-getMetadataByUUID"></a>}}
\if{latex}{\out{\hypertarget{method-GNOpenAPIManager-getMetadataByUUID}{}}}
\subsection{Method \code{getMetadataByUUID()}}{
Get a metadata by UUID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNOpenAPIManager$getMetadataByUUID(
  uuid,
  addSchemaLocation = TRUE,
  increasePopularity = TRUE,
  approved = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{uuid}

\item{\code{addSchemaLocation}}{add schema location. Default is \code{TRUE}}

\item{\code{increasePopularity}}{increase popularity. Default is \code{TRUE}}

\item{\code{approved}}{approved}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns an object of class \code{ISOMetadata} (ISO 19115)
or \code{ISOFeatureCatalogue} (ISO 19110) (from \pkg{geometa} package)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNOpenAPIManager-insertRecord"></a>}}
\if{latex}{\out{\hypertarget{method-GNOpenAPIManager-insertRecord}{}}}
\subsection{Method \code{insertRecord()}}{
Inserts a record by file, XML object or \pkg{geometa} object of class \code{ISOMetadata} or \code{ISOFeatureCatalogue}. 
   Extra parameters related to \pkg{geometa} objects: \code{geometa_validate} (TRUE by default) and \code{geometa_inspire} 
   (FALSE by default) can be used to perform ISO and INSPIRE validation respectively. In that case on object of class 
   \code{geometa::INSPIREMetadataValidator}, with a proper user API key, should be specified as \code{geometa_inspireValidator} 
   argument.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNOpenAPIManager$insertRecord(
  xml = NULL,
  file = NULL,
  geometa = NULL,
  metadataType = "METADATA",
  uuidProcessing = "NOTHING",
  group,
  category = NULL,
  rejectIfInvalid = FALSE,
  publishToAll = TRUE,
  transformWith = "_none_",
  schema = NULL,
  extra = NULL,
  geometa_validate = TRUE,
  geometa_inspire = FALSE,
  geometa_inspireValidator = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{XMLInternalNode-class} from \pkg{XML}}

\item{\code{file}}{file}

\item{\code{geometa}}{geometa object of class \code{ISOMetadata} or \code{ISOFeatureCatalogue}}

\item{\code{metadataType}}{metadata type. By default \code{METADATA}}

\item{\code{uuidProcessing}}{UUID processing. By default \code{NOTHING}. Other possible value: \code{OVERWRITE}}

\item{\code{group}}{group}

\item{\code{category}}{category}

\item{\code{rejectIfInvalid}}{reject if invalid. Default \code{FALSE}}

\item{\code{publishToAll}}{publish to all. Default \code{TRUE}}

\item{\code{transformWith}}{transform with. Default is \code{_none_}}

\item{\code{schema}}{schema}

\item{\code{extra}}{extra}

\item{\code{geometa_validate}}{validate geometa object}

\item{\code{geometa_inspire}}{validate geometa object vs. INSPIRE}

\item{\code{geometa_inspireValidator}}{geometa INSPIRE validator to use}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNOpenAPIManager-insertMetadata"></a>}}
\if{latex}{\out{\hypertarget{method-GNOpenAPIManager-insertMetadata}{}}}
\subsection{Method \code{insertMetadata()}}{
Inserts a metadata by file, XML object or \pkg{geometa} object of class \code{ISOMetadata} or \code{ISOFeatureCatalogue}. 
   Extra parameters related to \pkg{geometa} objects: \code{geometa_validate} (TRUE by default) and \code{geometa_inspire} 
   (FALSE by default) can be used to perform ISO and INSPIRE validation respectively. In that case on object of class 
   \code{geometa::INSPIREMetadataValidator}, with a proper user API key, should be specified as
   \code{geometa_inspireValidator} argument.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNOpenAPIManager$insertMetadata(
  xml = NULL,
  file = NULL,
  geometa = NULL,
  metadataType = "METADATA",
  uuidProcessing = "NOTHING",
  group,
  category = NULL,
  rejectIfInvalid = FALSE,
  publishToAll = TRUE,
  transformWith = "_none_",
  schema = NULL,
  extra = NULL,
  geometa_validate = TRUE,
  geometa_inspire = FALSE,
  geometa_inspireValidator = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{XMLInternalNode-class} from \pkg{XML}}

\item{\code{file}}{file}

\item{\code{geometa}}{geometa object of class \code{ISOMetadata} or \code{ISOFeatureCatalogue}}

\item{\code{metadataType}}{metadata type. By default \code{METADATA}}

\item{\code{uuidProcessing}}{UUID processing. By default \code{NOTHING}. Other possible value: \code{OVERWRITE}}

\item{\code{group}}{group}

\item{\code{category}}{category}

\item{\code{rejectIfInvalid}}{reject if invalid. Default \code{FALSE}}

\item{\code{publishToAll}}{publish to all. Default \code{TRUE}}

\item{\code{transformWith}}{transform with. Default is \code{_none_}}

\item{\code{schema}}{schema}

\item{\code{extra}}{extra}

\item{\code{geometa_validate}}{validate geometa object}

\item{\code{geometa_inspire}}{validate geometa object vs. INSPIRE}

\item{\code{geometa_inspireValidator}}{geometa INSPIRE validator to use}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNOpenAPIManager-updateMetadata"></a>}}
\if{latex}{\out{\hypertarget{method-GNOpenAPIManager-updateMetadata}{}}}
\subsection{Method \code{updateMetadata()}}{
Inserts a metadata by file, XML object or \pkg{geometa} object of class \code{ISOMetadata} or \code{ISOFeatureCatalogue}. 
   Extra parameters related to \pkg{geometa} objects: \code{geometa_validate} (TRUE by default) and \code{geometa_inspire} 
   (FALSE by default) can be used to perform ISO and INSPIRE validation respectively. In that case on object of class 
   \code{geometa::INSPIREMetadataValidator}, with a proper user API key, should be specified as
   \code{geometa_inspireValidator} argument.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNOpenAPIManager$updateMetadata(
  xml = NULL,
  file = NULL,
  geometa = NULL,
  metadataType = "METADATA",
  group,
  category = NULL,
  rejectIfInvalid = FALSE,
  publishToAll = TRUE,
  transformWith = "_none_",
  schema = NULL,
  extra = NULL,
  geometa_validate = TRUE,
  geometa_inspire = FALSE,
  geometa_inspireValidator = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{XMLInternalNode-class} from \pkg{XML}}

\item{\code{file}}{file}

\item{\code{geometa}}{geometa object of class \code{ISOMetadata} or \code{ISOFeatureCatalogue}}

\item{\code{metadataType}}{metadata type. By default \code{METADATA}}

\item{\code{group}}{group}

\item{\code{category}}{category}

\item{\code{rejectIfInvalid}}{reject if invalid. Default \code{FALSE}}

\item{\code{publishToAll}}{publish to all. Default \code{TRUE}}

\item{\code{transformWith}}{transform with. Default is \code{_none_}}

\item{\code{schema}}{schema}

\item{\code{extra}}{extra}

\item{\code{geometa_validate}}{validate geometa object}

\item{\code{geometa_inspire}}{validate geometa object vs. INSPIRE}

\item{\code{geometa_inspireValidator}}{geometa INSPIRE validator to use}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNOpenAPIManager-deleteMetadata"></a>}}
\if{latex}{\out{\hypertarget{method-GNOpenAPIManager-deleteMetadata}{}}}
\subsection{Method \code{deleteMetadata()}}{
Deletes a metadata by ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNOpenAPIManager$deleteMetadata(id, withBackup = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{id}

\item{\code{withBackup}}{proceed with backup. Default is \code{TRUE}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNOpenAPIManager-uploadAttachment"></a>}}
\if{latex}{\out{\hypertarget{method-GNOpenAPIManager-uploadAttachment}{}}}
\subsection{Method \code{uploadAttachment()}}{
Uploads attachment
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNOpenAPIManager$uploadAttachment(
  id,
  file,
  visibility = "public",
  approved = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{metadata identifier}

\item{\code{file}}{file to upload}

\item{\code{visibility}}{public or private}

\item{\code{approved}}{object of class \code{logical}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a named list of the uploaded attachment, including the url, size, id and type, \code{NULL} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNOpenAPIManager-publishThumbnail"></a>}}
\if{latex}{\out{\hypertarget{method-GNOpenAPIManager-publishThumbnail}{}}}
\subsection{Method \code{publishThumbnail()}}{
Publishes thumbnail based on URL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNOpenAPIManager$publishThumbnail(id, url, desc = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{metadata identifier}

\item{\code{url}}{thumbnail URL}

\item{\code{desc}}{thumbnail description}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if published, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNOpenAPIManager-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GNOpenAPIManager-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNOpenAPIManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
