% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define.links.r
\name{define.links}
\alias{define.links}
\title{Define links between landmarks}
\usage{
define.links(spec, ptsize = 1, links = NULL)
}
\arguments{
\item{spec}{Name of specimen, as an object matrix containing 2D or 3D landmark coordinates}

\item{ptsize}{Numeric Size to plot the landmarks}

\item{links}{Optional An existing links matrix to add on to}
}
\value{
Function returns a matrix of which landmarks will be links
to be used by \code{\link{plotAllSpecimens}} & \code{\link{plotRefToTarget}} option 'links='.
}
\description{
An interactive function to define which landmarks should be linked to aid visualization.
}
\details{
Function takes a matrix of digitized landmark coordinates (e.g. from \code{\link{mshape}}) and 
allows the user to define pairs of landmarks to be linked, for visualization purposes. The output is a matrix 
to be used by \code{\link{plotAllSpecimens}} & \code{\link{plotRefToTarget}} option 'links='.  
 
 \subsection{Selection}{ 
 In the plot window select two landmarks that will be linked. In the console, the user will be prompted
 to continue linking landmarks to build the wireframe or end the session (typing y or n respectively).
 For 2D data in plot window, use LEFT mouse button to select landmarks.
 For 3D data in rgl window, use RIGHT mouse button (or command+LEFT for mac) to select landmarks.
}
}
\author{
Emma Sherratt
}
\seealso{
\code{\link{plotAllSpecimens}}

\code{\link{plotRefToTarget}}
}
\keyword{utilities}

