% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/advanced.procD.lm.r
\name{advanced.procD.lm}
\alias{advanced.procD.lm}
\title{Procrustes ANOVA and pairwise tests for shape data, using complex linear models}
\usage{
advanced.procD.lm(f1, f2, groups = NULL, slope = NULL, angle.type = c("r",
  "deg", "rad"), iter = 999, verbose = FALSE, ...)
}
\arguments{
\item{f1}{A formula for a linear model, containing the response matrix (e.g., y ~ x1 + x2)}

\item{f2}{A formula for another linear model (e.g., ~ x1 + x2 + x3 + a*b) (f1 and f2 should be nested)}

\item{groups}{A formula for grouping factors (e.g., ~ a, or ~ a*b)}

\item{slope}{A formula with one covariate (e.g., ~ x3)}

\item{angle.type}{A value specifying whether differences between slopes should be represented by vector
correlations (r), radians (rad) or degrees (deg)}

\item{iter}{Number of iterations for significance testing}

\item{verbose}{A logical value specifying whether additional output should be displayed (see Value below)}

\item{...}{Arguments passed on to procD.fit (typically associated with the lm function)}
}
\value{
Function returns an ANOVA table of statistical results for model comparison: error df (for each model), SS, MS,
F ratio, Z, and Prand.  The following may also be returned.
  \item{Means.dist}{Pairwise distance between means, if applicable}
  \item{LS.Means.dist}{Pairwise distance between LS means, if applicable}
  \item{Prob.Means.dist}{P-values for pairwise distances between means}
  \item{Slopes.dist}{Pairwise distance between slope vectors (difference in amount of shape change), if applicable}
  \item{Prob.Slopes.dist}{P-values for pairwise distances between slopes}
  \item{Slopes.correlation}{Pairwise vector correlations between slope vectors, if applicable}
  \item{Prob.Slopes.cor}{P-values for pairwise correlations between slope vectors (high correlation less significant)}
  \item{Slopes.angle}{Angles between between slope vectors, if applicable}
  \item{Prob.Slopes.angle}{P-values for pairwise angles between slope vectors}
  \item{SS.rand}{Random SS from RRPP permutations (when {verbose=TRUE})}
  \item{random.mean.dist}{random pairwise distances between means from RRPP permutations (when {verbose=TRUE})}
  \item{random.slope.dist}{random pairwise distances between slopes from RRPP permutations (when {verbose=TRUE})}
  \item{random.slope.comp}{random pairwise slope direction comparisons (r or angle) from RRPP permutations (when {verbose=TRUE})}
}
\description{
The function quantifies the relative amount of shape variation explained by  a suite of factors
and covariates in a "full" model, after accounting for variation in a "reduced" model. Inputs are
formulae for full and reduced models (order is not important), plus indication if means or slopes
are to be comapred among groups, with appropriate formulae to define how they should be compared.
}
\details{
The response matrix 'y' can be in the form of a two-dimensional data
  matrix of dimension (n x [p x k]) or a 3D array (p x k x n). It is assumed that the landmarks have previously
  been aligned using Generalized Procrustes Analysis (GPA) [e.g., with \code{\link{gpagen}}]. The names specified for the
  independent (x) variables in the formula represent one or more
  vectors containing continuous data or factors. It is assumed that the order of the specimens in the
  shape matrix matches the order of values in the independent variables. Linear model fits (using the  \code{\link{lm}} function)
  can also be input in place of a formula.  Arguments for \code{\link{lm}} can also be passed on via this function.

The function performs statistical assessment of the terms in the model using Procrustes distances among
  specimens, rather than explained covariance matrices among variables. With this approach, the sum-of-squared
  Procrustes distances are used as a measure of SS (see Goodall 1991). The SS betwen models is evaluated through
  permutation. In morphometrics this approach is known as a Procrustes ANOVA (Goodall 1991), which is equivalent
  to distance-based anova designs (Anderson 2001). Unlike \code{\link{procD.lm}}, this function is strictly for comparison
  of two nested models. The function will readily accept non-nested models, but the results will not be meaningful.
  (Use of \code{\link{procD.lm}} will be more suitable in most cases.)
  A residual randomization permutation procedure (RRPP) is utilized
  for reduced model residuals to evalute the SS between models (Collyer et al. 2015).  Effect-sizes (Z-scores) are
  computed as standard deviates of the SS sampling
  distributions generated, which might be more intuitive for P-values than F-values (see Collyer et al. 2015).

Pairwise tests are only performed if formulae are provided to compute such results.
}
\examples{
data(plethodon)
Y.gpa<-gpagen(plethodon$land)    #GPA-alignment
Y<-two.d.array(Y.gpa$coords)
CS <- Y.gpa$Csize
sp<- plethodon$species
st<- plethodon$site

# Example of a nested model comparison (as with ANOVA with RRPP)
advanced.procD.lm(Y ~ log(CS) + sp, ~ log(CS)*sp*st, iter=19)

# Example of a test of a factor interaction, plus pairwise comparisons (replaces pairwiseD.test)
advanced.procD.lm(Y ~ st*sp, ~st + sp, groups = ~st*sp, iter=19)

# Example of a test of a factor interaction, plus pairwise comparisons,
# accounting for a common allomtry  (replaces pairwiseD.test)
advanced.procD.lm(Y ~ log(CS) + st*sp,
~log(CS) + st + sp,
groups = ~st*sp, slope = ~log(CS), iter=19)

# Example of a test of homogeneity of slopes, plus pairwise slopes comparisons
# (replaces pairwise.slope.test)
advanced.procD.lm(Y ~ log(CS)*st*sp,
~log(CS) + st*sp,
groups = ~st*sp, slope = ~log(CS), angle.type = "deg", iter=19)

# Example of partial pairwise comparisons, given greater model complexity
advanced.procD.lm(Y ~ log(CS)*st*sp,
~log(CS) + st*sp,
groups = ~sp, slope = ~log(CS), angle.type = "deg", iter=19)
}
\author{
Michael Collyer
}
\references{
Collyer, M.L., D.J. Sekora, and D.C. Adams. 2015. A method for analysis of phenotypic change for phenotypes described
by high-dimensional data. Heredity. 115:357-365.
}
\seealso{
\code{\link{procD.lm}}
}
\keyword{analysis}

