% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOCoupledResource.R
\docType{class}
\name{ISOCoupledResource}
\alias{ISOCoupledResource}
\title{ISOCoupledResource}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISOCoupledResource
}
\description{
ISOCoupledResource
}
\section{Fields}{

\describe{
\item{\code{operationName}}{[\code{\link{character}}] operation name}

\item{\code{identifier}}{[\code{\link{character}}] identifier}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOCoupledResource}}
 }
 \item{\code{setOperationName(operationName, locales)}}{
   Set the operation name. Locale names can be specified 
   as \code{list} with the \code{locales} argument.
 }
 \item{\code{setIdentifier(identifier, locales)}}{
   Set the identifier. Locale names can be specified 
   as \code{list} with the \code{locales} argument.
 }
}
}

\examples{
  md <- ISOCoupledResource$new()
  md$setOperationName("name")
  md$setIdentifier("identifier")
  xml <- md$encode()

}
\references{
ISO 19119:2005 - Geographic information -- Services
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{CoupledResource}
\keyword{ISO}
