% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOFormat.R
\docType{class}
\name{ISOFormat}
\alias{ISOFormat}
\title{ISOFormat}
\format{\code{\link{R6Class}} object.}
\usage{
ISOFormat
}
\value{
Object of \code{\link{R6Class}} for modelling an ISOFormat
}
\description{
ISOFormat
}
\section{Fields}{

\describe{
\item{\code{name}}{[\code{\link{character}}] format name}

\item{\code{version}}{[\code{\link{character}}] format version}

\item{\code{amendmentNumber}}{[\code{\link{character}}] format amendment number}

\item{\code{specification}}{[\code{\link{character}}] format specification}

\item{\code{fileDecompressionTechnique}}{[\code{\link{character}}] technique for file decompression}

\item{\code{formatDistributor}}{[\code{\link{ISODistributor}}] format distributor}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISOFormat
 }
 \item{\code{setName(name, locales)}}{
   Sets the format name. Locale names can be 
   specified as \code{list} with the \code{locales} argument.
 }
 \item{\code{setVersion(version)}}{
   Sets the format version
 }
 \item{\code{setAmendmentNumber(amendmentNumber)}}{
   Sets an admenment number
 }
 \item{\code{setSpecification(specification, locales)}}{
   Sets the format specification. Locale names can be 
   specified as \code{list} with the \code{locales} argument.
 }
 \item{\code{setFileDecompressionTechnique(technique)}}{
   Sets the file decompression technique
 }
 \item{\code{addDistributor(distributor)}}{
   Adds a distributor, object of class \code{ISODistributor}
 }
 \item{\code{delDistributor(distributor)}}{
   Deletes a distributor, object of class \code{ISODistributor}
 }
}
}

\examples{
 md <- ISOFormat$new()
 md$setName("name")
 md$setVersion("1.0")
 md$setAmendmentNumber("2")
 md$setSpecification("specification")
 
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{format}
