% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ISODimension.R
\docType{class}
\name{ISODimension}
\alias{ISODimension}
\title{ISODimension}
\format{\code{\link{R6Class}} object.}
\usage{
ISODimension
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Dimension
}
\description{
ISODimension
}
\section{Fields}{

\describe{
\item{\code{dimensionName}}{}

\item{\code{dimensionSize}}{}

\item{\code{resolution}}{}
}}
\section{Methods}{

\describe{
 \item{\code{new(xml,value)}}{
   This method is used to instantiate an ISODimension
 }
 \item{\code{setName(name)}}{
   Sets the dimension name. Object of class \code{ISODimensionNameType} or
   any value from \code{ISODimensionNameType$values()}
 }
 \item{\code{setSize(size)}}{
   Sets the dimension size, object of class \code{integer}
 }
 \item{\code{setResolution(resolution)}}{
  Sets the resolution ie. object of class \code{ISOMeasure} or any subclass
  \code{ISOLength}, \code{ISODistance}, \code{ISOAngle}, \code{ISOScale}
 }
}
}
\examples{
#create dimension
   md <- ISODimension$new()
   md$setName("row")
   md$setSize(1)
   md$setResolution(ISOLength$new(value=1,uom="m"))
   xml <- md$encode()
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\keyword{ISO}
\keyword{dimension}

