% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{inv_powerlaw}
\alias{inv_powerlaw}
\alias{neg_expo}
\title{Dispersal kernels}
\usage{
inv_powerlaw(
  params = load_parameters(),
  betas = NULL,
  mets = NULL,
  we = NULL,
  linkcutoff = NULL
)

neg_expo(
  params = load_parameters(),
  gammas = NULL,
  mets = NULL,
  we = NULL,
  linkcutoff = NULL
)
}
\arguments{
\item{params}{Object. This function uses the parameter values defined in \code{\link[=load_parameters]{load_parameters()}} by default.
If \code{\link[=load_parameters]{load_parameters()}} is not provided, the function will require the user to specify all arguments as listed below.
If both \code{\link[=load_parameters]{load_parameters()}} and values for the arguments listed below are provided, \code{\link[=load_parameters]{load_parameters()}} takes precedence over the specified arguments.}

\item{betas}{Numeric. Beta is the dispersal parameter used in the inverse power law to estimate a species' dispersal gradient. Please refer to Mundt et al (2009) for details on how to calculate this parameter. Any beta values should be positive. Smaller beta values indicate a higher likelihood of dispersal between nodes.}

\item{mets}{Character. There are seven network metrics supported by \code{geohabnet}:  "node_strength", "sum_of_nearest_neighbors", "eigenvector_centrality", "closeness", "betweeness", "degree", and "page_rank".
Each specified network metric is calculated for each location in the target region, based on the link weights between each pair of locations. Run, for example, \code{\link[=pagerank]{pagerank()}} for details of each network metric.}

\item{we}{Numeric. This parameter indicates the weight(s) of each specified network metric, representing the importance of the network metric in the analysis. Since these weights represent percentages, any weight(s) should be between 0 and 100, and the sum of all specified weights should be 100.}

\item{linkcutoff}{Numeric. This parameter is only used to calculate \code{\link[=betweeness]{betweeness()}} and \code{\link[=closeness]{closeness()}}, and is equivalent to \code{cutoff} in these functions in the \code{igraph} package.}

\item{gammas}{Numeric. Gamma is the dispersal parameter used in the negative exponential to estimate a species' dispersal gradient. Any gamma values should be positive. Smaller gamma values indicate a higher likelihood of dispersal between nodes.}
}
\value{
List with parameters and values. See details.
}
\description{
-\verb{[inv_powerlaw()]} Get parameters and values pertaining to the inverse power law model.
-\verb{[neg_exp()]} Get parameters and values pertaining to the negative exponential model.
}
\details{
Refer to Esker et al (2007) for a discussion on the characteristics of each dispersal gradient or kernel model (i.e., inverse power law and negative exponential). The resulting object produced by \code{\link[=load_parameters]{load_parameters()}} provides the following values used when running the analysis
-\code{beta} is a dispersal parameter for calculating the inverse power law model.
-\code{gamma} is a dispersal parameter for calculating the negative exponential model.
-\code{metrics} Each network metric is applied to the adjacency matrix produced in the intermediate step.
-\code{weights} The link weights that is used in the network analysis.
-\code{cutoff} Currently used as a parameter to calculate centrality in the network - \code{\link[=betweeness]{betweeness()}} and \code{\link[=closeness]{closeness()}}.
As defined in \code{\link[igraph:betweenness]{igraph::betweenness()}}, it's the maximum length to consider when calculating centrality.
If zero or negative, then there is no such limit.
}
\references{
Esker PD, Sparks AH, Antony G, Bates M, Dall' Acqua W, Frank EE, Huebel L, Segovia V, Garrett KA (2007).
“Ecology and Epidemiology in R: Modeling dispersal gradients.” \emph{The Plant Health Instructor}.
\doi{10.1094/PHI-A-2008-0129-03}

Mundt CC, Sackett KE, Wallace LD, Cowger C, Dudley JP  (2009).
“Aerial Dispersal and Multiple-Scale Spread of Epidemic Disease.” \emph{Ecohealth}.
\doi{https://doi.org/10.1007/s10393-009-0251-z}

Csardi G, Nepusz T (2006).
“The igraph software package for complex network research.” \emph{InterJournal}, \emph{Complex Systems}, 1695.
\url{https://igraph.org}.

Csárdi G, Nepusz T, Traag V, Horvát Sz, Zanini F, Noom D, Müller K (2024).
\emph{igraph: Network Analysis and Visualization in R}.
\doi{10.5281/zenodo.7682609},
R package version 1.5.1, \url{https://CRAN.R-project.org/package=igraph}.
}
\seealso{
\code{\link[=supported_metrics]{supported_metrics()}}
}
