% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cassini.R
\name{cassini_fwd}
\alias{cassini_fwd}
\alias{cassini_rev}
\title{Cassini-Soldner projection}
\usage{
cassini_fwd(x, lon0, lat0)

cassini_rev(x, y, lon0, lat0)
}
\arguments{
\item{x}{For forward conversion: a two-column matrix or data frame of
coordinates (longitude, latitude) in decimal degrees.
For reverse conversion: numeric vector of x (easting) coordinates in meters.}

\item{lon0}{Longitude of the central meridian in decimal degrees.}

\item{lat0}{Latitude of the origin in decimal degrees.}

\item{y}{Numeric vector of y (northing) coordinates in meters.}
}
\value{
Data frame with columns:
\itemize{
\item For forward conversion:
\itemize{
\item \code{x}: Easting in meters
\item \code{y}: Northing in meters
\item \code{azi}: Azimuth of the geodesic from the central point (degrees)
\item \code{rk}: Reciprocal of the azimuthal scale
\item \code{lon}, \code{lat}: Input coordinates (echoed)
}
\item For reverse conversion:
\itemize{
\item \code{lon}: Longitude in decimal degrees
\item \code{lat}: Latitude in decimal degrees
\item \code{azi}: Azimuth of the geodesic from the central point (degrees)
\item \code{rk}: Reciprocal of the azimuthal scale
\item \code{x}, \code{y}: Input coordinates (echoed)
}
}
}
\description{
Convert between geographic coordinates and the Cassini-Soldner projection.
This is a transverse cylindrical equidistant projection historically used
for large-scale mapping.
}
\details{
The Cassini-Soldner projection was historically used for large-scale
topographic mapping before UTM became standard. It is still used in some
countries and for historical map analysis.

Key properties:
\itemize{
\item Distances along the central meridian are preserved
\item Transverse cylindrical equidistant projection
\item Not conformal (angles are not preserved)
}
}
\examples{
# Project relative to a central meridian
pts <- cbind(lon = c(-100, -99, -101), lat = c(40, 41, 39))
cassini_fwd(pts, lon0 = -100, lat0 = 40)

# Round-trip
fwd <- cassini_fwd(pts, lon0 = -100, lat0 = 40)
cassini_rev(fwd$x, fwd$y, lon0 = -100, lat0 = 40)
}
\seealso{
\code{\link[=utmups_fwd]{utmups_fwd()}} for UTM projection, \code{\link[=lcc_fwd]{lcc_fwd()}} for Lambert
Conformal Conic
}
